package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  NonBlankAndLengthConstraintString,
  AliasIdOrArn
}
import scala.jdk.CollectionConverters._
final case class UpdateAliasRequest(
    aliasId: AliasIdOrArn,
    name: Option[NonBlankAndLengthConstraintString] = None,
    description: Option[NonZeroAndMaxString] = None,
    routingStrategy: Option[zio.aws.gamelift.model.RoutingStrategy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateAliasRequest = {
    import UpdateAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateAliasRequest
      .builder()
      .aliasId(AliasIdOrArn.unwrap(aliasId): java.lang.String)
      .optionallyWith(
        name.map(value =>
          NonBlankAndLengthConstraintString.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(routingStrategy.map(value => value.buildAwsValue()))(
        _.routingStrategy
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateAliasRequest.ReadOnly =
    zio.aws.gamelift.model.UpdateAliasRequest.wrap(buildAwsValue())
}
object UpdateAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateAliasRequest =
      zio.aws.gamelift.model.UpdateAliasRequest(
        aliasId,
        name.map(value => value),
        description.map(value => value),
        routingStrategy.map(value => value.asEditable)
      )
    def aliasId: AliasIdOrArn
    def name: Option[NonBlankAndLengthConstraintString]
    def description: Option[NonZeroAndMaxString]
    def routingStrategy: Option[zio.aws.gamelift.model.RoutingStrategy.ReadOnly]
    def getAliasId: ZIO[Any, Nothing, AliasIdOrArn] = ZIO.succeed(aliasId)
    def getName: ZIO[Any, AwsError, NonBlankAndLengthConstraintString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("description", description)
    def getRoutingStrategy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.RoutingStrategy.ReadOnly] =
      AwsError.unwrapOptionField("routingStrategy", routingStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateAliasRequest
  ) extends zio.aws.gamelift.model.UpdateAliasRequest.ReadOnly {
    override val aliasId: AliasIdOrArn =
      zio.aws.gamelift.model.primitives.AliasIdOrArn(impl.aliasId())
    override val name: Option[NonBlankAndLengthConstraintString] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives
          .NonBlankAndLengthConstraintString(value)
      )
    override val description: Option[NonZeroAndMaxString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val routingStrategy
        : Option[zio.aws.gamelift.model.RoutingStrategy.ReadOnly] = scala
      .Option(impl.routingStrategy())
      .map(value => zio.aws.gamelift.model.RoutingStrategy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateAliasRequest
  ): zio.aws.gamelift.model.UpdateAliasRequest.ReadOnly = new Wrapper(impl)
}
