package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.FleetId
import scala.jdk.CollectionConverters._
final case class UpdateFleetAttributesResponse(
    fleetId: Option[FleetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse = {
    import UpdateFleetAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.UpdateFleetAttributesResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateFleetAttributesResponse.wrap(buildAwsValue())
}
object UpdateFleetAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateFleetAttributesResponse =
      zio.aws.gamelift.model
        .UpdateFleetAttributesResponse(fleetId.map(value => value))
    def fleetId: Option[FleetId]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse
  ) extends zio.aws.gamelift.model.UpdateFleetAttributesResponse.ReadOnly {
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse
  ): zio.aws.gamelift.model.UpdateFleetAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
