package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  LocationStringModel,
  WholeNumber,
  FleetIdOrArn
}
import scala.jdk.CollectionConverters._
final case class UpdateFleetCapacityRequest(
    fleetId: FleetIdOrArn,
    desiredInstances: Option[WholeNumber] = None,
    minSize: Option[WholeNumber] = None,
    maxSize: Option[WholeNumber] = None,
    location: Option[LocationStringModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest = {
    import UpdateFleetCapacityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        desiredInstances.map(value => WholeNumber.unwrap(value): Integer)
      )(_.desiredInstances)
      .optionallyWith(minSize.map(value => WholeNumber.unwrap(value): Integer))(
        _.minSize
      )
      .optionallyWith(maxSize.map(value => WholeNumber.unwrap(value): Integer))(
        _.maxSize
      )
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateFleetCapacityRequest.ReadOnly =
    zio.aws.gamelift.model.UpdateFleetCapacityRequest.wrap(buildAwsValue())
}
object UpdateFleetCapacityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateFleetCapacityRequest =
      zio.aws.gamelift.model.UpdateFleetCapacityRequest(
        fleetId,
        desiredInstances.map(value => value),
        minSize.map(value => value),
        maxSize.map(value => value),
        location.map(value => value)
      )
    def fleetId: FleetIdOrArn
    def desiredInstances: Option[WholeNumber]
    def minSize: Option[WholeNumber]
    def maxSize: Option[WholeNumber]
    def location: Option[LocationStringModel]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getDesiredInstances: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("desiredInstances", desiredInstances)
    def getMinSize: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("minSize", minSize)
    def getMaxSize: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("maxSize", maxSize)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest
  ) extends zio.aws.gamelift.model.UpdateFleetCapacityRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val desiredInstances: Option[WholeNumber] = scala
      .Option(impl.desiredInstances())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val minSize: Option[WholeNumber] = scala
      .Option(impl.minSize())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val maxSize: Option[WholeNumber] = scala
      .Option(impl.maxSize())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest
  ): zio.aws.gamelift.model.UpdateFleetCapacityRequest.ReadOnly = new Wrapper(
    impl
  )
}
