package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateGameServerGroupResponse(
    gameServerGroup: Option[zio.aws.gamelift.model.GameServerGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupResponse = {
    import UpdateGameServerGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupResponse
      .builder()
      .optionallyWith(gameServerGroup.map(value => value.buildAwsValue()))(
        _.gameServerGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.UpdateGameServerGroupResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateGameServerGroupResponse.wrap(buildAwsValue())
}
object UpdateGameServerGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateGameServerGroupResponse =
      zio.aws.gamelift.model.UpdateGameServerGroupResponse(
        gameServerGroup.map(value => value.asEditable)
      )
    def gameServerGroup: Option[zio.aws.gamelift.model.GameServerGroup.ReadOnly]
    def getGameServerGroup
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServerGroup.ReadOnly] =
      AwsError.unwrapOptionField("gameServerGroup", gameServerGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupResponse
  ) extends zio.aws.gamelift.model.UpdateGameServerGroupResponse.ReadOnly {
    override val gameServerGroup
        : Option[zio.aws.gamelift.model.GameServerGroup.ReadOnly] = scala
      .Option(impl.gameServerGroup())
      .map(value => zio.aws.gamelift.model.GameServerGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupResponse
  ): zio.aws.gamelift.model.UpdateGameServerGroupResponse.ReadOnly =
    new Wrapper(impl)
}
