package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateGameServerResponse(
    gameServer: Option[zio.aws.gamelift.model.GameServer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateGameServerResponse = {
    import UpdateGameServerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateGameServerResponse
      .builder()
      .optionallyWith(gameServer.map(value => value.buildAwsValue()))(
        _.gameServer
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateGameServerResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateGameServerResponse.wrap(buildAwsValue())
}
object UpdateGameServerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateGameServerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateGameServerResponse =
      zio.aws.gamelift.model
        .UpdateGameServerResponse(gameServer.map(value => value.asEditable))
    def gameServer: Option[zio.aws.gamelift.model.GameServer.ReadOnly]
    def getGameServer
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServer.ReadOnly] =
      AwsError.unwrapOptionField("gameServer", gameServer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameServerResponse
  ) extends zio.aws.gamelift.model.UpdateGameServerResponse.ReadOnly {
    override val gameServer
        : Option[zio.aws.gamelift.model.GameServer.ReadOnly] = scala
      .Option(impl.gameServer())
      .map(value => zio.aws.gamelift.model.GameServer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameServerResponse
  ): zio.aws.gamelift.model.UpdateGameServerResponse.ReadOnly = new Wrapper(
    impl
  )
}
