package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  QueueSnsArnStringModel,
  QueueCustomEventData,
  WholeNumber,
  GameSessionQueueNameOrArn
}
import scala.jdk.CollectionConverters._
final case class UpdateGameSessionQueueRequest(
    name: GameSessionQueueNameOrArn,
    timeoutInSeconds: Option[WholeNumber] = None,
    playerLatencyPolicies: Option[
      Iterable[zio.aws.gamelift.model.PlayerLatencyPolicy]
    ] = None,
    destinations: Option[
      Iterable[zio.aws.gamelift.model.GameSessionQueueDestination]
    ] = None,
    filterConfiguration: Option[zio.aws.gamelift.model.FilterConfiguration] =
      None,
    priorityConfiguration: Option[
      zio.aws.gamelift.model.PriorityConfiguration
    ] = None,
    customEventData: Option[QueueCustomEventData] = None,
    notificationTarget: Option[QueueSnsArnStringModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueRequest = {
    import UpdateGameSessionQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueRequest
      .builder()
      .name(GameSessionQueueNameOrArn.unwrap(name): java.lang.String)
      .optionallyWith(
        timeoutInSeconds.map(value => WholeNumber.unwrap(value): Integer)
      )(_.timeoutInSeconds)
      .optionallyWith(
        playerLatencyPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.playerLatencyPolicies)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(filterConfiguration.map(value => value.buildAwsValue()))(
        _.filterConfiguration
      )
      .optionallyWith(
        priorityConfiguration.map(value => value.buildAwsValue())
      )(_.priorityConfiguration)
      .optionallyWith(
        customEventData.map(value =>
          QueueCustomEventData.unwrap(value): java.lang.String
        )
      )(_.customEventData)
      .optionallyWith(
        notificationTarget.map(value =>
          QueueSnsArnStringModel.unwrap(value): java.lang.String
        )
      )(_.notificationTarget)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.UpdateGameSessionQueueRequest.ReadOnly =
    zio.aws.gamelift.model.UpdateGameSessionQueueRequest.wrap(buildAwsValue())
}
object UpdateGameSessionQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateGameSessionQueueRequest =
      zio.aws.gamelift.model.UpdateGameSessionQueueRequest(
        name,
        timeoutInSeconds.map(value => value),
        playerLatencyPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filterConfiguration.map(value => value.asEditable),
        priorityConfiguration.map(value => value.asEditable),
        customEventData.map(value => value),
        notificationTarget.map(value => value)
      )
    def name: GameSessionQueueNameOrArn
    def timeoutInSeconds: Option[WholeNumber]
    def playerLatencyPolicies
        : Option[List[zio.aws.gamelift.model.PlayerLatencyPolicy.ReadOnly]]
    def destinations: Option[
      List[zio.aws.gamelift.model.GameSessionQueueDestination.ReadOnly]
    ]
    def filterConfiguration
        : Option[zio.aws.gamelift.model.FilterConfiguration.ReadOnly]
    def priorityConfiguration
        : Option[zio.aws.gamelift.model.PriorityConfiguration.ReadOnly]
    def customEventData: Option[QueueCustomEventData]
    def notificationTarget: Option[QueueSnsArnStringModel]
    def getName: ZIO[Any, Nothing, GameSessionQueueNameOrArn] =
      ZIO.succeed(name)
    def getTimeoutInSeconds: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("timeoutInSeconds", timeoutInSeconds)
    def getPlayerLatencyPolicies: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.PlayerLatencyPolicy.ReadOnly
    ]] =
      AwsError.unwrapOptionField("playerLatencyPolicies", playerLatencyPolicies)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameSessionQueueDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getFilterConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.FilterConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("filterConfiguration", filterConfiguration)
    def getPriorityConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.PriorityConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("priorityConfiguration", priorityConfiguration)
    def getCustomEventData: ZIO[Any, AwsError, QueueCustomEventData] =
      AwsError.unwrapOptionField("customEventData", customEventData)
    def getNotificationTarget: ZIO[Any, AwsError, QueueSnsArnStringModel] =
      AwsError.unwrapOptionField("notificationTarget", notificationTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueRequest
  ) extends zio.aws.gamelift.model.UpdateGameSessionQueueRequest.ReadOnly {
    override val name: GameSessionQueueNameOrArn =
      zio.aws.gamelift.model.primitives.GameSessionQueueNameOrArn(impl.name())
    override val timeoutInSeconds: Option[WholeNumber] = scala
      .Option(impl.timeoutInSeconds())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val playerLatencyPolicies
        : Option[List[zio.aws.gamelift.model.PlayerLatencyPolicy.ReadOnly]] =
      scala
        .Option(impl.playerLatencyPolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.PlayerLatencyPolicy.wrap(item)
          }.toList
        )
    override val destinations: Option[
      List[zio.aws.gamelift.model.GameSessionQueueDestination.ReadOnly]
    ] = scala
      .Option(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.GameSessionQueueDestination.wrap(item)
        }.toList
      )
    override val filterConfiguration
        : Option[zio.aws.gamelift.model.FilterConfiguration.ReadOnly] = scala
      .Option(impl.filterConfiguration())
      .map(value => zio.aws.gamelift.model.FilterConfiguration.wrap(value))
    override val priorityConfiguration
        : Option[zio.aws.gamelift.model.PriorityConfiguration.ReadOnly] = scala
      .Option(impl.priorityConfiguration())
      .map(value => zio.aws.gamelift.model.PriorityConfiguration.wrap(value))
    override val customEventData: Option[QueueCustomEventData] = scala
      .Option(impl.customEventData())
      .map(value =>
        zio.aws.gamelift.model.primitives.QueueCustomEventData(value)
      )
    override val notificationTarget: Option[QueueSnsArnStringModel] = scala
      .Option(impl.notificationTarget())
      .map(value =>
        zio.aws.gamelift.model.primitives.QueueSnsArnStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueRequest
  ): zio.aws.gamelift.model.UpdateGameSessionQueueRequest.ReadOnly =
    new Wrapper(impl)
}
