package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  WholeNumber,
  ArnStringModel
}
import scala.jdk.CollectionConverters._
final case class UpdateGameSessionRequest(
    gameSessionId: ArnStringModel,
    maximumPlayerSessionCount: Option[WholeNumber] = None,
    name: Option[NonZeroAndMaxString] = None,
    playerSessionCreationPolicy: Option[
      zio.aws.gamelift.model.PlayerSessionCreationPolicy
    ] = None,
    protectionPolicy: Option[zio.aws.gamelift.model.ProtectionPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateGameSessionRequest = {
    import UpdateGameSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateGameSessionRequest
      .builder()
      .gameSessionId(ArnStringModel.unwrap(gameSessionId): java.lang.String)
      .optionallyWith(
        maximumPlayerSessionCount.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.maximumPlayerSessionCount)
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(playerSessionCreationPolicy.map(value => value.unwrap))(
        _.playerSessionCreationPolicy
      )
      .optionallyWith(protectionPolicy.map(value => value.unwrap))(
        _.protectionPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateGameSessionRequest.ReadOnly =
    zio.aws.gamelift.model.UpdateGameSessionRequest.wrap(buildAwsValue())
}
object UpdateGameSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateGameSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateGameSessionRequest =
      zio.aws.gamelift.model.UpdateGameSessionRequest(
        gameSessionId,
        maximumPlayerSessionCount.map(value => value),
        name.map(value => value),
        playerSessionCreationPolicy.map(value => value),
        protectionPolicy.map(value => value)
      )
    def gameSessionId: ArnStringModel
    def maximumPlayerSessionCount: Option[WholeNumber]
    def name: Option[NonZeroAndMaxString]
    def playerSessionCreationPolicy
        : Option[zio.aws.gamelift.model.PlayerSessionCreationPolicy]
    def protectionPolicy: Option[zio.aws.gamelift.model.ProtectionPolicy]
    def getGameSessionId: ZIO[Any, Nothing, ArnStringModel] =
      ZIO.succeed(gameSessionId)
    def getMaximumPlayerSessionCount: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("maximumPlayerSessionCount", maximumPlayerSessionCount)
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getPlayerSessionCreationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.PlayerSessionCreationPolicy
    ] = AwsError.unwrapOptionField(
      "playerSessionCreationPolicy",
      playerSessionCreationPolicy
    )
    def getProtectionPolicy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ProtectionPolicy] =
      AwsError.unwrapOptionField("protectionPolicy", protectionPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameSessionRequest
  ) extends zio.aws.gamelift.model.UpdateGameSessionRequest.ReadOnly {
    override val gameSessionId: ArnStringModel =
      zio.aws.gamelift.model.primitives.ArnStringModel(impl.gameSessionId())
    override val maximumPlayerSessionCount: Option[WholeNumber] = scala
      .Option(impl.maximumPlayerSessionCount())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val name: Option[NonZeroAndMaxString] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val playerSessionCreationPolicy
        : Option[zio.aws.gamelift.model.PlayerSessionCreationPolicy] = scala
      .Option(impl.playerSessionCreationPolicy())
      .map(value =>
        zio.aws.gamelift.model.PlayerSessionCreationPolicy.wrap(value)
      )
    override val protectionPolicy
        : Option[zio.aws.gamelift.model.ProtectionPolicy] = scala
      .Option(impl.protectionPolicy())
      .map(value => zio.aws.gamelift.model.ProtectionPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameSessionRequest
  ): zio.aws.gamelift.model.UpdateGameSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
