package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateGameSessionResponse(
    gameSession: Option[zio.aws.gamelift.model.GameSession] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse = {
    import UpdateGameSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse
      .builder()
      .optionallyWith(gameSession.map(value => value.buildAwsValue()))(
        _.gameSession
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateGameSessionResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateGameSessionResponse.wrap(buildAwsValue())
}
object UpdateGameSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateGameSessionResponse =
      zio.aws.gamelift.model
        .UpdateGameSessionResponse(gameSession.map(value => value.asEditable))
    def gameSession: Option[zio.aws.gamelift.model.GameSession.ReadOnly]
    def getGameSession
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameSession.ReadOnly] =
      AwsError.unwrapOptionField("gameSession", gameSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse
  ) extends zio.aws.gamelift.model.UpdateGameSessionResponse.ReadOnly {
    override val gameSession
        : Option[zio.aws.gamelift.model.GameSession.ReadOnly] = scala
      .Option(impl.gameSession())
      .map(value => zio.aws.gamelift.model.GameSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse
  ): zio.aws.gamelift.model.UpdateGameSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
