package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateMatchmakingConfigurationResponse(
    configuration: Option[zio.aws.gamelift.model.MatchmakingConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationResponse = {
    import UpdateMatchmakingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationResponse
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.UpdateMatchmakingConfigurationResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateMatchmakingConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateMatchmakingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.UpdateMatchmakingConfigurationResponse =
      zio.aws.gamelift.model.UpdateMatchmakingConfigurationResponse(
        configuration.map(value => value.asEditable)
      )
    def configuration
        : Option[zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationResponse
  ) extends zio.aws.gamelift.model.UpdateMatchmakingConfigurationResponse.ReadOnly {
    override val configuration
        : Option[zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly] =
      scala
        .Option(impl.configuration())
        .map(value =>
          zio.aws.gamelift.model.MatchmakingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationResponse
  ): zio.aws.gamelift.model.UpdateMatchmakingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
