package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.FleetIdOrArn
import scala.jdk.CollectionConverters._
final case class UpdateRuntimeConfigurationRequest(
    fleetId: FleetIdOrArn,
    runtimeConfiguration: zio.aws.gamelift.model.RuntimeConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationRequest = {
    import UpdateRuntimeConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .runtimeConfiguration(runtimeConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.UpdateRuntimeConfigurationRequest.ReadOnly =
    zio.aws.gamelift.model.UpdateRuntimeConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateRuntimeConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateRuntimeConfigurationRequest =
      zio.aws.gamelift.model.UpdateRuntimeConfigurationRequest(
        fleetId,
        runtimeConfiguration.asEditable
      )
    def fleetId: FleetIdOrArn
    def runtimeConfiguration
        : zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getRuntimeConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly
    ] = ZIO.succeed(runtimeConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationRequest
  ) extends zio.aws.gamelift.model.UpdateRuntimeConfigurationRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val runtimeConfiguration
        : zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly =
      zio.aws.gamelift.model.RuntimeConfiguration
        .wrap(impl.runtimeConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationRequest
  ): zio.aws.gamelift.model.UpdateRuntimeConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
