package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  ZipBlob,
  NonZeroAndMaxString,
  ScriptIdOrArn
}
import scala.jdk.CollectionConverters._
final case class UpdateScriptRequest(
    scriptId: ScriptIdOrArn,
    name: Option[NonZeroAndMaxString] = None,
    version: Option[NonZeroAndMaxString] = None,
    storageLocation: Option[zio.aws.gamelift.model.S3Location] = None,
    zipFile: Option[ZipBlob] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateScriptRequest = {
    import UpdateScriptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateScriptRequest
      .builder()
      .scriptId(ScriptIdOrArn.unwrap(scriptId): java.lang.String)
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.version)
      .optionallyWith(storageLocation.map(value => value.buildAwsValue()))(
        _.storageLocation
      )
      .optionallyWith(
        zipFile.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.zipFile)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateScriptRequest.ReadOnly =
    zio.aws.gamelift.model.UpdateScriptRequest.wrap(buildAwsValue())
}
object UpdateScriptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateScriptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateScriptRequest =
      zio.aws.gamelift.model.UpdateScriptRequest(
        scriptId,
        name.map(value => value),
        version.map(value => value),
        storageLocation.map(value => value.asEditable),
        zipFile.map(value => value)
      )
    def scriptId: ScriptIdOrArn
    def name: Option[NonZeroAndMaxString]
    def version: Option[NonZeroAndMaxString]
    def storageLocation: Option[zio.aws.gamelift.model.S3Location.ReadOnly]
    def zipFile: Option[ZipBlob]
    def getScriptId: ZIO[Any, Nothing, ScriptIdOrArn] = ZIO.succeed(scriptId)
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("version", version)
    def getStorageLocation
        : ZIO[Any, AwsError, zio.aws.gamelift.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("storageLocation", storageLocation)
    def getZipFile: ZIO[Any, AwsError, ZipBlob] =
      AwsError.unwrapOptionField("zipFile", zipFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateScriptRequest
  ) extends zio.aws.gamelift.model.UpdateScriptRequest.ReadOnly {
    override val scriptId: ScriptIdOrArn =
      zio.aws.gamelift.model.primitives.ScriptIdOrArn(impl.scriptId())
    override val name: Option[NonZeroAndMaxString] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val version: Option[NonZeroAndMaxString] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val storageLocation
        : Option[zio.aws.gamelift.model.S3Location.ReadOnly] = scala
      .Option(impl.storageLocation())
      .map(value => zio.aws.gamelift.model.S3Location.wrap(value))
    override val zipFile: Option[ZipBlob] = scala
      .Option(impl.zipFile())
      .map(value =>
        zio.aws.gamelift.model.primitives
          .ZipBlob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateScriptRequest
  ): zio.aws.gamelift.model.UpdateScriptRequest.ReadOnly = new Wrapper(impl)
}
