package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateScriptResponse(
    script: Option[zio.aws.gamelift.model.Script] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateScriptResponse = {
    import UpdateScriptResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateScriptResponse
      .builder()
      .optionallyWith(script.map(value => value.buildAwsValue()))(_.script)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateScriptResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateScriptResponse.wrap(buildAwsValue())
}
object UpdateScriptResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateScriptResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateScriptResponse =
      zio.aws.gamelift.model
        .UpdateScriptResponse(script.map(value => value.asEditable))
    def script: Option[zio.aws.gamelift.model.Script.ReadOnly]
    def getScript: ZIO[Any, AwsError, zio.aws.gamelift.model.Script.ReadOnly] =
      AwsError.unwrapOptionField("script", script)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateScriptResponse
  ) extends zio.aws.gamelift.model.UpdateScriptResponse.ReadOnly {
    override val script: Option[zio.aws.gamelift.model.Script.ReadOnly] = scala
      .Option(impl.script())
      .map(value => zio.aws.gamelift.model.Script.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateScriptResponse
  ): zio.aws.gamelift.model.UpdateScriptResponse.ReadOnly = new Wrapper(impl)
}
