package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.gamelift.model.primitives.{Timestamp, NonZeroAndMaxString}
import scala.jdk.CollectionConverters._
final case class VpcPeeringAuthorization(
    gameLiftAwsAccountId: Option[NonZeroAndMaxString] = None,
    peerVpcAwsAccountId: Option[NonZeroAndMaxString] = None,
    peerVpcId: Option[NonZeroAndMaxString] = None,
    creationTime: Option[Timestamp] = None,
    expirationTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.VpcPeeringAuthorization = {
    import VpcPeeringAuthorization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.VpcPeeringAuthorization
      .builder()
      .optionallyWith(
        gameLiftAwsAccountId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameLiftAwsAccountId)
      .optionallyWith(
        peerVpcAwsAccountId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.peerVpcAwsAccountId)
      .optionallyWith(
        peerVpcId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.peerVpcId)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        expirationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationTime)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.VpcPeeringAuthorization.ReadOnly =
    zio.aws.gamelift.model.VpcPeeringAuthorization.wrap(buildAwsValue())
}
object VpcPeeringAuthorization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.VpcPeeringAuthorization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.VpcPeeringAuthorization =
      zio.aws.gamelift.model.VpcPeeringAuthorization(
        gameLiftAwsAccountId.map(value => value),
        peerVpcAwsAccountId.map(value => value),
        peerVpcId.map(value => value),
        creationTime.map(value => value),
        expirationTime.map(value => value)
      )
    def gameLiftAwsAccountId: Option[NonZeroAndMaxString]
    def peerVpcAwsAccountId: Option[NonZeroAndMaxString]
    def peerVpcId: Option[NonZeroAndMaxString]
    def creationTime: Option[Timestamp]
    def expirationTime: Option[Timestamp]
    def getGameLiftAwsAccountId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameLiftAwsAccountId", gameLiftAwsAccountId)
    def getPeerVpcAwsAccountId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("peerVpcAwsAccountId", peerVpcAwsAccountId)
    def getPeerVpcId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("peerVpcId", peerVpcId)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getExpirationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.VpcPeeringAuthorization
  ) extends zio.aws.gamelift.model.VpcPeeringAuthorization.ReadOnly {
    override val gameLiftAwsAccountId: Option[NonZeroAndMaxString] = scala
      .Option(impl.gameLiftAwsAccountId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val peerVpcAwsAccountId: Option[NonZeroAndMaxString] = scala
      .Option(impl.peerVpcAwsAccountId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val peerVpcId: Option[NonZeroAndMaxString] = scala
      .Option(impl.peerVpcId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val expirationTime: Option[Timestamp] = scala
      .Option(impl.expirationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.VpcPeeringAuthorization
  ): zio.aws.gamelift.model.VpcPeeringAuthorization.ReadOnly = new Wrapper(impl)
}
