package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{DoubleObject, NonZeroAndMaxString}
import scala.jdk.CollectionConverters._
final case class AttributeValue(
    s: Optional[NonZeroAndMaxString] = Optional.Absent,
    n: Optional[DoubleObject] = Optional.Absent,
    sl: Optional[Iterable[NonZeroAndMaxString]] = Optional.Absent,
    sdm: Optional[Map[NonZeroAndMaxString, DoubleObject]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.AttributeValue = {
    import AttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.AttributeValue
      .builder()
      .optionallyWith(
        s.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.s)
      .optionallyWith(n.map(value => value: java.lang.Double))(_.n)
      .optionallyWith(
        sl.map(value =>
          value.map { item =>
            NonZeroAndMaxString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sl)
      .optionallyWith(
        sdm.map(value =>
          value
            .map({ case (key, value) =>
              (NonZeroAndMaxString
                .unwrap(key): java.lang.String) -> (value: java.lang.Double)
            })
            .asJava
        )
      )(_.sdm)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.AttributeValue.ReadOnly =
    zio.aws.gamelift.model.AttributeValue.wrap(buildAwsValue())
}
object AttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.AttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.AttributeValue =
      zio.aws.gamelift.model.AttributeValue(
        s.map(value => value),
        n.map(value => value),
        sl.map(value => value),
        sdm.map(value => value)
      )
    def s: Optional[NonZeroAndMaxString]
    def n: Optional[DoubleObject]
    def sl: Optional[List[NonZeroAndMaxString]]
    def sdm: Optional[Map[NonZeroAndMaxString, DoubleObject]]
    def getS: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("s", s)
    def getN: ZIO[Any, AwsError, DoubleObject] =
      AwsError.unwrapOptionField("n", n)
    def getSl: ZIO[Any, AwsError, List[NonZeroAndMaxString]] =
      AwsError.unwrapOptionField("sl", sl)
    def getSdm: ZIO[Any, AwsError, Map[NonZeroAndMaxString, DoubleObject]] =
      AwsError.unwrapOptionField("sdm", sdm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.AttributeValue
  ) extends zio.aws.gamelift.model.AttributeValue.ReadOnly {
    override val s: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.s())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val n: Optional[DoubleObject] = zio.aws.core.internal
      .optionalFromNullable(impl.n())
      .map(value => value: DoubleObject)
    override val sl: Optional[List[NonZeroAndMaxString]] = zio.aws.core.internal
      .optionalFromNullable(impl.sl())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(item)
        }.toList
      )
    override val sdm: Optional[Map[NonZeroAndMaxString, DoubleObject]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sdm())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.gamelift.model.primitives
                .NonZeroAndMaxString(key) -> (value: DoubleObject)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.AttributeValue
  ): zio.aws.gamelift.model.AttributeValue.ReadOnly = new Wrapper(impl)
}
