package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait BackfillMode {
  def unwrap: software.amazon.awssdk.services.gamelift.model.BackfillMode
}
object BackfillMode {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.BackfillMode
  ): zio.aws.gamelift.model.BackfillMode = value match {
    case software.amazon.awssdk.services.gamelift.model.BackfillMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.BackfillMode.AUTOMATIC =>
      val r = AUTOMATIC
      r
    case software.amazon.awssdk.services.gamelift.model.BackfillMode.MANUAL =>
      val r = MANUAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.gamelift.model.BackfillMode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.BackfillMode =
      software.amazon.awssdk.services.gamelift.model.BackfillMode.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTOMATIC extends zio.aws.gamelift.model.BackfillMode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.BackfillMode =
      software.amazon.awssdk.services.gamelift.model.BackfillMode.AUTOMATIC
  }
  case object MANUAL extends zio.aws.gamelift.model.BackfillMode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.BackfillMode =
      software.amazon.awssdk.services.gamelift.model.BackfillMode.MANUAL
  }
}
