package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  FreeText,
  PositiveLong,
  Timestamp,
  BuildArn,
  BuildId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Build(
    buildId: Optional[BuildId] = Optional.Absent,
    buildArn: Optional[BuildArn] = Optional.Absent,
    name: Optional[FreeText] = Optional.Absent,
    version: Optional[FreeText] = Optional.Absent,
    status: Optional[zio.aws.gamelift.model.BuildStatus] = Optional.Absent,
    sizeOnDisk: Optional[PositiveLong] = Optional.Absent,
    operatingSystem: Optional[zio.aws.gamelift.model.OperatingSystem] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.gamelift.model.Build = {
    import Build.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.Build
      .builder()
      .optionallyWith(
        buildId.map(value => BuildId.unwrap(value): java.lang.String)
      )(_.buildId)
      .optionallyWith(
        buildArn.map(value => BuildArn.unwrap(value): java.lang.String)
      )(_.buildArn)
      .optionallyWith(
        name.map(value => FreeText.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => FreeText.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        sizeOnDisk.map(value => PositiveLong.unwrap(value): java.lang.Long)
      )(_.sizeOnDisk)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.Build.ReadOnly =
    zio.aws.gamelift.model.Build.wrap(buildAwsValue())
}
object Build {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.gamelift.model.Build] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.Build = zio.aws.gamelift.model.Build(
      buildId.map(value => value),
      buildArn.map(value => value),
      name.map(value => value),
      version.map(value => value),
      status.map(value => value),
      sizeOnDisk.map(value => value),
      operatingSystem.map(value => value),
      creationTime.map(value => value)
    )
    def buildId: Optional[BuildId]
    def buildArn: Optional[BuildArn]
    def name: Optional[FreeText]
    def version: Optional[FreeText]
    def status: Optional[zio.aws.gamelift.model.BuildStatus]
    def sizeOnDisk: Optional[PositiveLong]
    def operatingSystem: Optional[zio.aws.gamelift.model.OperatingSystem]
    def creationTime: Optional[Timestamp]
    def getBuildId: ZIO[Any, AwsError, BuildId] =
      AwsError.unwrapOptionField("buildId", buildId)
    def getBuildArn: ZIO[Any, AwsError, BuildArn] =
      AwsError.unwrapOptionField("buildArn", buildArn)
    def getName: ZIO[Any, AwsError, FreeText] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, FreeText] =
      AwsError.unwrapOptionField("version", version)
    def getStatus: ZIO[Any, AwsError, zio.aws.gamelift.model.BuildStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSizeOnDisk: ZIO[Any, AwsError, PositiveLong] =
      AwsError.unwrapOptionField("sizeOnDisk", sizeOnDisk)
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.gamelift.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.Build
  ) extends zio.aws.gamelift.model.Build.ReadOnly {
    override val buildId: Optional[BuildId] = zio.aws.core.internal
      .optionalFromNullable(impl.buildId())
      .map(value => zio.aws.gamelift.model.primitives.BuildId(value))
    override val buildArn: Optional[BuildArn] = zio.aws.core.internal
      .optionalFromNullable(impl.buildArn())
      .map(value => zio.aws.gamelift.model.primitives.BuildArn(value))
    override val name: Optional[FreeText] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.gamelift.model.primitives.FreeText(value))
    override val version: Optional[FreeText] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.gamelift.model.primitives.FreeText(value))
    override val status: Optional[zio.aws.gamelift.model.BuildStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.gamelift.model.BuildStatus.wrap(value))
    override val sizeOnDisk: Optional[PositiveLong] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeOnDisk())
      .map(value => zio.aws.gamelift.model.primitives.PositiveLong(value))
    override val operatingSystem
        : Optional[zio.aws.gamelift.model.OperatingSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value => zio.aws.gamelift.model.OperatingSystem.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.Build
  ): zio.aws.gamelift.model.Build.ReadOnly = new Wrapper(impl)
}
