package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait BuildStatus {
  def unwrap: software.amazon.awssdk.services.gamelift.model.BuildStatus
}
object BuildStatus {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.BuildStatus
  ): zio.aws.gamelift.model.BuildStatus = value match {
    case software.amazon.awssdk.services.gamelift.model.BuildStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.BuildStatus.INITIALIZED =>
      val r = INITIALIZED
      r
    case software.amazon.awssdk.services.gamelift.model.BuildStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.gamelift.model.BuildStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.gamelift.model.BuildStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.BuildStatus =
      software.amazon.awssdk.services.gamelift.model.BuildStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIALIZED extends zio.aws.gamelift.model.BuildStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.BuildStatus =
      software.amazon.awssdk.services.gamelift.model.BuildStatus.INITIALIZED
  }
  case object READY extends zio.aws.gamelift.model.BuildStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.BuildStatus =
      software.amazon.awssdk.services.gamelift.model.BuildStatus.READY
  }
  case object FAILED extends zio.aws.gamelift.model.BuildStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.BuildStatus =
      software.amazon.awssdk.services.gamelift.model.BuildStatus.FAILED
  }
}
