package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  GameServerData,
  GameServerId,
  GameServerGroupNameOrArn
}
import scala.jdk.CollectionConverters._
final case class ClaimGameServerRequest(
    gameServerGroupName: GameServerGroupNameOrArn,
    gameServerId: Optional[GameServerId] = Optional.Absent,
    gameServerData: Optional[GameServerData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ClaimGameServerRequest = {
    import ClaimGameServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ClaimGameServerRequest
      .builder()
      .gameServerGroupName(
        GameServerGroupNameOrArn.unwrap(gameServerGroupName): java.lang.String
      )
      .optionallyWith(
        gameServerId.map(value => GameServerId.unwrap(value): java.lang.String)
      )(_.gameServerId)
      .optionallyWith(
        gameServerData.map(value =>
          GameServerData.unwrap(value): java.lang.String
        )
      )(_.gameServerData)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ClaimGameServerRequest.ReadOnly =
    zio.aws.gamelift.model.ClaimGameServerRequest.wrap(buildAwsValue())
}
object ClaimGameServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ClaimGameServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ClaimGameServerRequest =
      zio.aws.gamelift.model.ClaimGameServerRequest(
        gameServerGroupName,
        gameServerId.map(value => value),
        gameServerData.map(value => value)
      )
    def gameServerGroupName: GameServerGroupNameOrArn
    def gameServerId: Optional[GameServerId]
    def gameServerData: Optional[GameServerData]
    def getGameServerGroupName: ZIO[Any, Nothing, GameServerGroupNameOrArn] =
      ZIO.succeed(gameServerGroupName)
    def getGameServerId: ZIO[Any, AwsError, GameServerId] =
      AwsError.unwrapOptionField("gameServerId", gameServerId)
    def getGameServerData: ZIO[Any, AwsError, GameServerData] =
      AwsError.unwrapOptionField("gameServerData", gameServerData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ClaimGameServerRequest
  ) extends zio.aws.gamelift.model.ClaimGameServerRequest.ReadOnly {
    override val gameServerGroupName: GameServerGroupNameOrArn =
      zio.aws.gamelift.model.primitives
        .GameServerGroupNameOrArn(impl.gameServerGroupName())
    override val gameServerId: Optional[GameServerId] = zio.aws.core.internal
      .optionalFromNullable(impl.gameServerId())
      .map(value => zio.aws.gamelift.model.primitives.GameServerId(value))
    override val gameServerData: Optional[GameServerData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerData())
        .map(value => zio.aws.gamelift.model.primitives.GameServerData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ClaimGameServerRequest
  ): zio.aws.gamelift.model.ClaimGameServerRequest.ReadOnly = new Wrapper(impl)
}
