package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClaimGameServerResponse(
    gameServer: Optional[zio.aws.gamelift.model.GameServer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ClaimGameServerResponse = {
    import ClaimGameServerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ClaimGameServerResponse
      .builder()
      .optionallyWith(gameServer.map(value => value.buildAwsValue()))(
        _.gameServer
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ClaimGameServerResponse.ReadOnly =
    zio.aws.gamelift.model.ClaimGameServerResponse.wrap(buildAwsValue())
}
object ClaimGameServerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ClaimGameServerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ClaimGameServerResponse =
      zio.aws.gamelift.model
        .ClaimGameServerResponse(gameServer.map(value => value.asEditable))
    def gameServer: Optional[zio.aws.gamelift.model.GameServer.ReadOnly]
    def getGameServer
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServer.ReadOnly] =
      AwsError.unwrapOptionField("gameServer", gameServer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ClaimGameServerResponse
  ) extends zio.aws.gamelift.model.ClaimGameServerResponse.ReadOnly {
    override val gameServer
        : Optional[zio.aws.gamelift.model.GameServer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServer())
        .map(value => zio.aws.gamelift.model.GameServer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ClaimGameServerResponse
  ): zio.aws.gamelift.model.ClaimGameServerResponse.ReadOnly = new Wrapper(impl)
}
