package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class CreateBuildRequest(
    name: Optional[NonZeroAndMaxString] = Optional.Absent,
    version: Optional[NonZeroAndMaxString] = Optional.Absent,
    storageLocation: Optional[zio.aws.gamelift.model.S3Location] =
      Optional.Absent,
    operatingSystem: Optional[zio.aws.gamelift.model.OperatingSystem] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.gamelift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateBuildRequest = {
    import CreateBuildRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateBuildRequest
      .builder()
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.version)
      .optionallyWith(storageLocation.map(value => value.buildAwsValue()))(
        _.storageLocation
      )
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateBuildRequest.ReadOnly =
    zio.aws.gamelift.model.CreateBuildRequest.wrap(buildAwsValue())
}
object CreateBuildRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateBuildRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateBuildRequest =
      zio.aws.gamelift.model.CreateBuildRequest(
        name.map(value => value),
        version.map(value => value),
        storageLocation.map(value => value.asEditable),
        operatingSystem.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[NonZeroAndMaxString]
    def version: Optional[NonZeroAndMaxString]
    def storageLocation: Optional[zio.aws.gamelift.model.S3Location.ReadOnly]
    def operatingSystem: Optional[zio.aws.gamelift.model.OperatingSystem]
    def tags: Optional[List[zio.aws.gamelift.model.Tag.ReadOnly]]
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("version", version)
    def getStorageLocation
        : ZIO[Any, AwsError, zio.aws.gamelift.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("storageLocation", storageLocation)
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.gamelift.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getTags: ZIO[Any, AwsError, List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateBuildRequest
  ) extends zio.aws.gamelift.model.CreateBuildRequest.ReadOnly {
    override val name: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val version: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val storageLocation
        : Optional[zio.aws.gamelift.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageLocation())
        .map(value => zio.aws.gamelift.model.S3Location.wrap(value))
    override val operatingSystem
        : Optional[zio.aws.gamelift.model.OperatingSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value => zio.aws.gamelift.model.OperatingSystem.wrap(value))
    override val tags: Optional[List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateBuildRequest
  ): zio.aws.gamelift.model.CreateBuildRequest.ReadOnly = new Wrapper(impl)
}
