package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  ScriptIdOrArn,
  BuildIdOrArn,
  LaunchParametersStringModel,
  MetricGroup,
  NonZeroAndMaxString,
  LaunchPathStringModel,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class CreateFleetRequest(
    name: NonZeroAndMaxString,
    description: Optional[NonZeroAndMaxString] = Optional.Absent,
    buildId: Optional[BuildIdOrArn] = Optional.Absent,
    scriptId: Optional[ScriptIdOrArn] = Optional.Absent,
    serverLaunchPath: Optional[LaunchPathStringModel] = Optional.Absent,
    serverLaunchParameters: Optional[LaunchParametersStringModel] =
      Optional.Absent,
    logPaths: Optional[Iterable[NonZeroAndMaxString]] = Optional.Absent,
    ec2InstanceType: zio.aws.gamelift.model.EC2InstanceType,
    ec2InboundPermissions: Optional[
      Iterable[zio.aws.gamelift.model.IpPermission]
    ] = Optional.Absent,
    newGameSessionProtectionPolicy: Optional[
      zio.aws.gamelift.model.ProtectionPolicy
    ] = Optional.Absent,
    runtimeConfiguration: Optional[
      zio.aws.gamelift.model.RuntimeConfiguration
    ] = Optional.Absent,
    resourceCreationLimitPolicy: Optional[
      zio.aws.gamelift.model.ResourceCreationLimitPolicy
    ] = Optional.Absent,
    metricGroups: Optional[Iterable[MetricGroup]] = Optional.Absent,
    peerVpcAwsAccountId: Optional[NonZeroAndMaxString] = Optional.Absent,
    peerVpcId: Optional[NonZeroAndMaxString] = Optional.Absent,
    fleetType: Optional[zio.aws.gamelift.model.FleetType] = Optional.Absent,
    instanceRoleArn: Optional[NonEmptyString] = Optional.Absent,
    certificateConfiguration: Optional[
      zio.aws.gamelift.model.CertificateConfiguration
    ] = Optional.Absent,
    locations: Optional[
      Iterable[zio.aws.gamelift.model.LocationConfiguration]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.gamelift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateFleetRequest = {
    import CreateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateFleetRequest
      .builder()
      .name(NonZeroAndMaxString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        buildId.map(value => BuildIdOrArn.unwrap(value): java.lang.String)
      )(_.buildId)
      .optionallyWith(
        scriptId.map(value => ScriptIdOrArn.unwrap(value): java.lang.String)
      )(_.scriptId)
      .optionallyWith(
        serverLaunchPath.map(value =>
          LaunchPathStringModel.unwrap(value): java.lang.String
        )
      )(_.serverLaunchPath)
      .optionallyWith(
        serverLaunchParameters.map(value =>
          LaunchParametersStringModel.unwrap(value): java.lang.String
        )
      )(_.serverLaunchParameters)
      .optionallyWith(
        logPaths.map(value =>
          value.map { item =>
            NonZeroAndMaxString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logPaths)
      .ec2InstanceType(ec2InstanceType.unwrap)
      .optionallyWith(
        ec2InboundPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2InboundPermissions)
      .optionallyWith(
        newGameSessionProtectionPolicy.map(value => value.unwrap)
      )(_.newGameSessionProtectionPolicy)
      .optionallyWith(runtimeConfiguration.map(value => value.buildAwsValue()))(
        _.runtimeConfiguration
      )
      .optionallyWith(
        resourceCreationLimitPolicy.map(value => value.buildAwsValue())
      )(_.resourceCreationLimitPolicy)
      .optionallyWith(
        metricGroups.map(value =>
          value.map { item =>
            MetricGroup.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.metricGroups)
      .optionallyWith(
        peerVpcAwsAccountId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.peerVpcAwsAccountId)
      .optionallyWith(
        peerVpcId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.peerVpcId)
      .optionallyWith(fleetType.map(value => value.unwrap))(_.fleetType)
      .optionallyWith(
        instanceRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceRoleArn)
      .optionallyWith(
        certificateConfiguration.map(value => value.buildAwsValue())
      )(_.certificateConfiguration)
      .optionallyWith(
        locations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.locations)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateFleetRequest.ReadOnly =
    zio.aws.gamelift.model.CreateFleetRequest.wrap(buildAwsValue())
}
object CreateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateFleetRequest =
      zio.aws.gamelift.model.CreateFleetRequest(
        name,
        description.map(value => value),
        buildId.map(value => value),
        scriptId.map(value => value),
        serverLaunchPath.map(value => value),
        serverLaunchParameters.map(value => value),
        logPaths.map(value => value),
        ec2InstanceType,
        ec2InboundPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        newGameSessionProtectionPolicy.map(value => value),
        runtimeConfiguration.map(value => value.asEditable),
        resourceCreationLimitPolicy.map(value => value.asEditable),
        metricGroups.map(value => value),
        peerVpcAwsAccountId.map(value => value),
        peerVpcId.map(value => value),
        fleetType.map(value => value),
        instanceRoleArn.map(value => value),
        certificateConfiguration.map(value => value.asEditable),
        locations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: NonZeroAndMaxString
    def description: Optional[NonZeroAndMaxString]
    def buildId: Optional[BuildIdOrArn]
    def scriptId: Optional[ScriptIdOrArn]
    def serverLaunchPath: Optional[LaunchPathStringModel]
    def serverLaunchParameters: Optional[LaunchParametersStringModel]
    def logPaths: Optional[List[NonZeroAndMaxString]]
    def ec2InstanceType: zio.aws.gamelift.model.EC2InstanceType
    def ec2InboundPermissions
        : Optional[List[zio.aws.gamelift.model.IpPermission.ReadOnly]]
    def newGameSessionProtectionPolicy
        : Optional[zio.aws.gamelift.model.ProtectionPolicy]
    def runtimeConfiguration
        : Optional[zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly]
    def resourceCreationLimitPolicy
        : Optional[zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly]
    def metricGroups: Optional[List[MetricGroup]]
    def peerVpcAwsAccountId: Optional[NonZeroAndMaxString]
    def peerVpcId: Optional[NonZeroAndMaxString]
    def fleetType: Optional[zio.aws.gamelift.model.FleetType]
    def instanceRoleArn: Optional[NonEmptyString]
    def certificateConfiguration
        : Optional[zio.aws.gamelift.model.CertificateConfiguration.ReadOnly]
    def locations
        : Optional[List[zio.aws.gamelift.model.LocationConfiguration.ReadOnly]]
    def tags: Optional[List[zio.aws.gamelift.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, NonZeroAndMaxString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("description", description)
    def getBuildId: ZIO[Any, AwsError, BuildIdOrArn] =
      AwsError.unwrapOptionField("buildId", buildId)
    def getScriptId: ZIO[Any, AwsError, ScriptIdOrArn] =
      AwsError.unwrapOptionField("scriptId", scriptId)
    def getServerLaunchPath: ZIO[Any, AwsError, LaunchPathStringModel] =
      AwsError.unwrapOptionField("serverLaunchPath", serverLaunchPath)
    def getServerLaunchParameters
        : ZIO[Any, AwsError, LaunchParametersStringModel] = AwsError
      .unwrapOptionField("serverLaunchParameters", serverLaunchParameters)
    def getLogPaths: ZIO[Any, AwsError, List[NonZeroAndMaxString]] =
      AwsError.unwrapOptionField("logPaths", logPaths)
    def getEc2InstanceType
        : ZIO[Any, Nothing, zio.aws.gamelift.model.EC2InstanceType] =
      ZIO.succeed(ec2InstanceType)
    def getEc2InboundPermissions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.IpPermission.ReadOnly
    ]] =
      AwsError.unwrapOptionField("ec2InboundPermissions", ec2InboundPermissions)
    def getNewGameSessionProtectionPolicy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ProtectionPolicy] =
      AwsError.unwrapOptionField(
        "newGameSessionProtectionPolicy",
        newGameSessionProtectionPolicy
      )
    def getRuntimeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("runtimeConfiguration", runtimeConfiguration)
    def getResourceCreationLimitPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceCreationLimitPolicy",
      resourceCreationLimitPolicy
    )
    def getMetricGroups: ZIO[Any, AwsError, List[MetricGroup]] =
      AwsError.unwrapOptionField("metricGroups", metricGroups)
    def getPeerVpcAwsAccountId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("peerVpcAwsAccountId", peerVpcAwsAccountId)
    def getPeerVpcId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("peerVpcId", peerVpcId)
    def getFleetType: ZIO[Any, AwsError, zio.aws.gamelift.model.FleetType] =
      AwsError.unwrapOptionField("fleetType", fleetType)
    def getInstanceRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceRoleArn", instanceRoleArn)
    def getCertificateConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.CertificateConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "certificateConfiguration",
      certificateConfiguration
    )
    def getLocations: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.LocationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("locations", locations)
    def getTags: ZIO[Any, AwsError, List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateFleetRequest
  ) extends zio.aws.gamelift.model.CreateFleetRequest.ReadOnly {
    override val name: NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives.NonZeroAndMaxString(impl.name())
    override val description: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val buildId: Optional[BuildIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.buildId())
      .map(value => zio.aws.gamelift.model.primitives.BuildIdOrArn(value))
    override val scriptId: Optional[ScriptIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.scriptId())
      .map(value => zio.aws.gamelift.model.primitives.ScriptIdOrArn(value))
    override val serverLaunchPath: Optional[LaunchPathStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverLaunchPath())
        .map(value =>
          zio.aws.gamelift.model.primitives.LaunchPathStringModel(value)
        )
    override val serverLaunchParameters: Optional[LaunchParametersStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverLaunchParameters())
        .map(value =>
          zio.aws.gamelift.model.primitives.LaunchParametersStringModel(value)
        )
    override val logPaths: Optional[List[NonZeroAndMaxString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logPaths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.primitives.NonZeroAndMaxString(item)
          }.toList
        )
    override val ec2InstanceType: zio.aws.gamelift.model.EC2InstanceType =
      zio.aws.gamelift.model.EC2InstanceType.wrap(impl.ec2InstanceType())
    override val ec2InboundPermissions
        : Optional[List[zio.aws.gamelift.model.IpPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InboundPermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.IpPermission.wrap(item)
          }.toList
        )
    override val newGameSessionProtectionPolicy
        : Optional[zio.aws.gamelift.model.ProtectionPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newGameSessionProtectionPolicy())
        .map(value => zio.aws.gamelift.model.ProtectionPolicy.wrap(value))
    override val runtimeConfiguration
        : Optional[zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeConfiguration())
        .map(value => zio.aws.gamelift.model.RuntimeConfiguration.wrap(value))
    override val resourceCreationLimitPolicy: Optional[
      zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceCreationLimitPolicy())
      .map(value =>
        zio.aws.gamelift.model.ResourceCreationLimitPolicy.wrap(value)
      )
    override val metricGroups: Optional[List[MetricGroup]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.primitives.MetricGroup(item)
          }.toList
        )
    override val peerVpcAwsAccountId: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.peerVpcAwsAccountId())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val peerVpcId: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.peerVpcId())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val fleetType: Optional[zio.aws.gamelift.model.FleetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetType())
        .map(value => zio.aws.gamelift.model.FleetType.wrap(value))
    override val instanceRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceRoleArn())
        .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val certificateConfiguration
        : Optional[zio.aws.gamelift.model.CertificateConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateConfiguration())
        .map(value =>
          zio.aws.gamelift.model.CertificateConfiguration.wrap(value)
        )
    override val locations: Optional[
      List[zio.aws.gamelift.model.LocationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.locations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.LocationConfiguration.wrap(item)
        }.toList
      )
    override val tags: Optional[List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateFleetRequest
  ): zio.aws.gamelift.model.CreateFleetRequest.ReadOnly = new Wrapper(impl)
}
