package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{RuleSetBody, MatchmakingIdStringModel}
import scala.jdk.CollectionConverters._
final case class CreateMatchmakingRuleSetRequest(
    name: MatchmakingIdStringModel,
    ruleSetBody: RuleSetBody,
    tags: Optional[Iterable[zio.aws.gamelift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetRequest = {
    import CreateMatchmakingRuleSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetRequest
      .builder()
      .name(MatchmakingIdStringModel.unwrap(name): java.lang.String)
      .ruleSetBody(RuleSetBody.unwrap(ruleSetBody): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.CreateMatchmakingRuleSetRequest.ReadOnly =
    zio.aws.gamelift.model.CreateMatchmakingRuleSetRequest.wrap(buildAwsValue())
}
object CreateMatchmakingRuleSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateMatchmakingRuleSetRequest =
      zio.aws.gamelift.model.CreateMatchmakingRuleSetRequest(
        name,
        ruleSetBody,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: MatchmakingIdStringModel
    def ruleSetBody: RuleSetBody
    def tags: Optional[List[zio.aws.gamelift.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, MatchmakingIdStringModel] = ZIO.succeed(name)
    def getRuleSetBody: ZIO[Any, Nothing, RuleSetBody] =
      ZIO.succeed(ruleSetBody)
    def getTags: ZIO[Any, AwsError, List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetRequest
  ) extends zio.aws.gamelift.model.CreateMatchmakingRuleSetRequest.ReadOnly {
    override val name: MatchmakingIdStringModel =
      zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(impl.name())
    override val ruleSetBody: RuleSetBody =
      zio.aws.gamelift.model.primitives.RuleSetBody(impl.ruleSetBody())
    override val tags: Optional[List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetRequest
  ): zio.aws.gamelift.model.CreateMatchmakingRuleSetRequest.ReadOnly =
    new Wrapper(impl)
}
