package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.{FleetIdOrArn, NonZeroAndMaxString}
import scala.jdk.CollectionConverters._
final case class DeleteScalingPolicyRequest(
    name: NonZeroAndMaxString,
    fleetId: FleetIdOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyRequest = {
    import DeleteScalingPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyRequest
      .builder()
      .name(NonZeroAndMaxString.unwrap(name): java.lang.String)
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DeleteScalingPolicyRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteScalingPolicyRequest.wrap(buildAwsValue())
}
object DeleteScalingPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteScalingPolicyRequest =
      zio.aws.gamelift.model.DeleteScalingPolicyRequest(name, fleetId)
    def name: NonZeroAndMaxString
    def fleetId: FleetIdOrArn
    def getName: ZIO[Any, Nothing, NonZeroAndMaxString] = ZIO.succeed(name)
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyRequest
  ) extends zio.aws.gamelift.model.DeleteScalingPolicyRequest.ReadOnly {
    override val name: NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives.NonZeroAndMaxString(impl.name())
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyRequest
  ): zio.aws.gamelift.model.DeleteScalingPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
