package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribeFleetEventsResponse(
    events: Optional[Iterable[zio.aws.gamelift.model.Event]] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse = {
    import DescribeFleetEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse
      .builder()
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeFleetEventsResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetEventsResponse.wrap(buildAwsValue())
}
object DescribeFleetEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeFleetEventsResponse =
      zio.aws.gamelift.model.DescribeFleetEventsResponse(
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def events: Optional[List[zio.aws.gamelift.model.Event.ReadOnly]]
    def nextToken: Optional[NonZeroAndMaxString]
    def getEvents
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.Event.ReadOnly]] =
      AwsError.unwrapOptionField("events", events)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse
  ) extends zio.aws.gamelift.model.DescribeFleetEventsResponse.ReadOnly {
    override val events: Optional[List[zio.aws.gamelift.model.Event.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Event.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse
  ): zio.aws.gamelift.model.DescribeFleetEventsResponse.ReadOnly = new Wrapper(
    impl
  )
}
