package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  FleetArn,
  FleetIdOrArn
}
import scala.jdk.CollectionConverters._
final case class DescribeFleetLocationAttributesResponse(
    fleetId: Optional[FleetIdOrArn] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    locationAttributes: Optional[
      Iterable[zio.aws.gamelift.model.LocationAttributes]
    ] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse = {
    import DescribeFleetLocationAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetIdOrArn.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        locationAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.locationAttributes)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeFleetLocationAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse =
      zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        locationAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fleetId: Optional[FleetIdOrArn]
    def fleetArn: Optional[FleetArn]
    def locationAttributes
        : Optional[List[zio.aws.gamelift.model.LocationAttributes.ReadOnly]]
    def nextToken: Optional[NonZeroAndMaxString]
    def getFleetId: ZIO[Any, AwsError, FleetIdOrArn] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getLocationAttributes: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.LocationAttributes.ReadOnly
    ]] = AwsError.unwrapOptionField("locationAttributes", locationAttributes)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse
  ) extends zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly {
    override val fleetId: Optional[FleetIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetIdOrArn(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val locationAttributes
        : Optional[List[zio.aws.gamelift.model.LocationAttributes.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.LocationAttributes.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse
  ): zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
