package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  PositiveInteger,
  FleetIdOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeFleetUtilizationRequest(
    fleetIds: Optional[Iterable[FleetIdOrArn]] = Optional.Absent,
    limit: Optional[PositiveInteger] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest = {
    import DescribeFleetUtilizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest
      .builder()
      .optionallyWith(
        fleetIds.map(value =>
          value.map { item =>
            FleetIdOrArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.fleetIds)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetUtilizationRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetUtilizationRequest.wrap(buildAwsValue())
}
object DescribeFleetUtilizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeFleetUtilizationRequest =
      zio.aws.gamelift.model.DescribeFleetUtilizationRequest(
        fleetIds.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def fleetIds: Optional[List[FleetIdOrArn]]
    def limit: Optional[PositiveInteger]
    def nextToken: Optional[NonZeroAndMaxString]
    def getFleetIds: ZIO[Any, AwsError, List[FleetIdOrArn]] =
      AwsError.unwrapOptionField("fleetIds", fleetIds)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest
  ) extends zio.aws.gamelift.model.DescribeFleetUtilizationRequest.ReadOnly {
    override val fleetIds: Optional[List[FleetIdOrArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.FleetIdOrArn(item)
        }.toList
      )
    override val limit: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest
  ): zio.aws.gamelift.model.DescribeFleetUtilizationRequest.ReadOnly =
    new Wrapper(impl)
}
