package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  PositiveInteger,
  GameServerInstanceId,
  GameServerGroupNameOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeGameServerInstancesRequest(
    gameServerGroupName: GameServerGroupNameOrArn,
    instanceIds: Optional[Iterable[GameServerInstanceId]] = Optional.Absent,
    limit: Optional[PositiveInteger] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest = {
    import DescribeGameServerInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest
      .builder()
      .gameServerGroupName(
        GameServerGroupNameOrArn.unwrap(gameServerGroupName): java.lang.String
      )
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            GameServerInstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeGameServerInstancesRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeGameServerInstancesRequest
      .wrap(buildAwsValue())
}
object DescribeGameServerInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeGameServerInstancesRequest =
      zio.aws.gamelift.model.DescribeGameServerInstancesRequest(
        gameServerGroupName,
        instanceIds.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def gameServerGroupName: GameServerGroupNameOrArn
    def instanceIds: Optional[List[GameServerInstanceId]]
    def limit: Optional[PositiveInteger]
    def nextToken: Optional[NonZeroAndMaxString]
    def getGameServerGroupName: ZIO[Any, Nothing, GameServerGroupNameOrArn] =
      ZIO.succeed(gameServerGroupName)
    def getInstanceIds: ZIO[Any, AwsError, List[GameServerInstanceId]] =
      AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest
  ) extends zio.aws.gamelift.model.DescribeGameServerInstancesRequest.ReadOnly {
    override val gameServerGroupName: GameServerGroupNameOrArn =
      zio.aws.gamelift.model.primitives
        .GameServerGroupNameOrArn(impl.gameServerGroupName())
    override val instanceIds: Optional[List[GameServerInstanceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.primitives.GameServerInstanceId(item)
          }.toList
        )
    override val limit: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest
  ): zio.aws.gamelift.model.DescribeGameServerInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
