package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.MatchmakingIdStringModel
import scala.jdk.CollectionConverters._
final case class DescribeMatchmakingRequest(
    ticketIds: Iterable[MatchmakingIdStringModel]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRequest = {
    import DescribeMatchmakingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRequest
      .builder()
      .ticketIds(ticketIds.map { item =>
        MatchmakingIdStringModel.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeMatchmakingRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeMatchmakingRequest.wrap(buildAwsValue())
}
object DescribeMatchmakingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeMatchmakingRequest =
      zio.aws.gamelift.model.DescribeMatchmakingRequest(ticketIds)
    def ticketIds: List[MatchmakingIdStringModel]
    def getTicketIds: ZIO[Any, Nothing, List[MatchmakingIdStringModel]] =
      ZIO.succeed(ticketIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRequest
  ) extends zio.aws.gamelift.model.DescribeMatchmakingRequest.ReadOnly {
    override val ticketIds: List[MatchmakingIdStringModel] = impl
      .ticketIds()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRequest
  ): zio.aws.gamelift.model.DescribeMatchmakingRequest.ReadOnly = new Wrapper(
    impl
  )
}
