package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpcPeeringAuthorizationsResponse(
    vpcPeeringAuthorizations: Optional[
      Iterable[zio.aws.gamelift.model.VpcPeeringAuthorization]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsResponse = {
    import DescribeVpcPeeringAuthorizationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsResponse
      .builder()
      .optionallyWith(
        vpcPeeringAuthorizations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcPeeringAuthorizations)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsResponse
      .wrap(buildAwsValue())
}
object DescribeVpcPeeringAuthorizationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsResponse =
      zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsResponse(
        vpcPeeringAuthorizations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vpcPeeringAuthorizations: Optional[
      List[zio.aws.gamelift.model.VpcPeeringAuthorization.ReadOnly]
    ]
    def getVpcPeeringAuthorizations: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.VpcPeeringAuthorization.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "vpcPeeringAuthorizations",
      vpcPeeringAuthorizations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsResponse
  ) extends zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsResponse.ReadOnly {
    override val vpcPeeringAuthorizations: Optional[
      List[zio.aws.gamelift.model.VpcPeeringAuthorization.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcPeeringAuthorizations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.VpcPeeringAuthorization.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsResponse
  ): zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsResponse.ReadOnly =
    new Wrapper(impl)
}
