package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.FleetId
import scala.jdk.CollectionConverters._
final case class DescribeVpcPeeringConnectionsRequest(
    fleetId: Optional[FleetId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsRequest = {
    import DescribeVpcPeeringConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsRequest
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeVpcPeeringConnectionsRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeVpcPeeringConnectionsRequest
      .wrap(buildAwsValue())
}
object DescribeVpcPeeringConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeVpcPeeringConnectionsRequest =
      zio.aws.gamelift.model
        .DescribeVpcPeeringConnectionsRequest(fleetId.map(value => value))
    def fleetId: Optional[FleetId]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsRequest
  ) extends zio.aws.gamelift.model.DescribeVpcPeeringConnectionsRequest.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsRequest
  ): zio.aws.gamelift.model.DescribeVpcPeeringConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
