package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait FleetAction {
  def unwrap: software.amazon.awssdk.services.gamelift.model.FleetAction
}
object FleetAction {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.FleetAction
  ): zio.aws.gamelift.model.FleetAction = value match {
    case software.amazon.awssdk.services.gamelift.model.FleetAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.FleetAction.AUTO_SCALING =>
      val r = AUTO_SCALING
      r
  }
  case object unknownToSdkVersion extends zio.aws.gamelift.model.FleetAction {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.FleetAction =
      software.amazon.awssdk.services.gamelift.model.FleetAction.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO_SCALING extends zio.aws.gamelift.model.FleetAction {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.FleetAction =
      software.amazon.awssdk.services.gamelift.model.FleetAction.AUTO_SCALING
  }
}
