package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  FleetId,
  FleetArn,
  Timestamp,
  ScriptId,
  ScriptArn,
  BuildArn,
  LaunchParametersStringModel,
  BuildId,
  MetricGroup,
  NonZeroAndMaxString,
  LaunchPathStringModel,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class FleetAttributes(
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    fleetType: Optional[zio.aws.gamelift.model.FleetType] = Optional.Absent,
    instanceType: Optional[zio.aws.gamelift.model.EC2InstanceType] =
      Optional.Absent,
    description: Optional[NonZeroAndMaxString] = Optional.Absent,
    name: Optional[NonZeroAndMaxString] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    terminationTime: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.gamelift.model.FleetStatus] = Optional.Absent,
    buildId: Optional[BuildId] = Optional.Absent,
    buildArn: Optional[BuildArn] = Optional.Absent,
    scriptId: Optional[ScriptId] = Optional.Absent,
    scriptArn: Optional[ScriptArn] = Optional.Absent,
    serverLaunchPath: Optional[LaunchPathStringModel] = Optional.Absent,
    serverLaunchParameters: Optional[LaunchParametersStringModel] =
      Optional.Absent,
    logPaths: Optional[Iterable[NonZeroAndMaxString]] = Optional.Absent,
    newGameSessionProtectionPolicy: Optional[
      zio.aws.gamelift.model.ProtectionPolicy
    ] = Optional.Absent,
    operatingSystem: Optional[zio.aws.gamelift.model.OperatingSystem] =
      Optional.Absent,
    resourceCreationLimitPolicy: Optional[
      zio.aws.gamelift.model.ResourceCreationLimitPolicy
    ] = Optional.Absent,
    metricGroups: Optional[Iterable[MetricGroup]] = Optional.Absent,
    stoppedActions: Optional[Iterable[zio.aws.gamelift.model.FleetAction]] =
      Optional.Absent,
    instanceRoleArn: Optional[NonEmptyString] = Optional.Absent,
    certificateConfiguration: Optional[
      zio.aws.gamelift.model.CertificateConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.FleetAttributes = {
    import FleetAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.FleetAttributes
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(fleetType.map(value => value.unwrap))(_.fleetType)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        description.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        terminationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.terminationTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        buildId.map(value => BuildId.unwrap(value): java.lang.String)
      )(_.buildId)
      .optionallyWith(
        buildArn.map(value => BuildArn.unwrap(value): java.lang.String)
      )(_.buildArn)
      .optionallyWith(
        scriptId.map(value => ScriptId.unwrap(value): java.lang.String)
      )(_.scriptId)
      .optionallyWith(
        scriptArn.map(value => ScriptArn.unwrap(value): java.lang.String)
      )(_.scriptArn)
      .optionallyWith(
        serverLaunchPath.map(value =>
          LaunchPathStringModel.unwrap(value): java.lang.String
        )
      )(_.serverLaunchPath)
      .optionallyWith(
        serverLaunchParameters.map(value =>
          LaunchParametersStringModel.unwrap(value): java.lang.String
        )
      )(_.serverLaunchParameters)
      .optionallyWith(
        logPaths.map(value =>
          value.map { item =>
            NonZeroAndMaxString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logPaths)
      .optionallyWith(
        newGameSessionProtectionPolicy.map(value => value.unwrap)
      )(_.newGameSessionProtectionPolicy)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(
        resourceCreationLimitPolicy.map(value => value.buildAwsValue())
      )(_.resourceCreationLimitPolicy)
      .optionallyWith(
        metricGroups.map(value =>
          value.map { item =>
            MetricGroup.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.metricGroups)
      .optionallyWith(
        stoppedActions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.stoppedActionsWithStrings)
      .optionallyWith(
        instanceRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceRoleArn)
      .optionallyWith(
        certificateConfiguration.map(value => value.buildAwsValue())
      )(_.certificateConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.FleetAttributes.ReadOnly =
    zio.aws.gamelift.model.FleetAttributes.wrap(buildAwsValue())
}
object FleetAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.FleetAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.FleetAttributes =
      zio.aws.gamelift.model.FleetAttributes(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        fleetType.map(value => value),
        instanceType.map(value => value),
        description.map(value => value),
        name.map(value => value),
        creationTime.map(value => value),
        terminationTime.map(value => value),
        status.map(value => value),
        buildId.map(value => value),
        buildArn.map(value => value),
        scriptId.map(value => value),
        scriptArn.map(value => value),
        serverLaunchPath.map(value => value),
        serverLaunchParameters.map(value => value),
        logPaths.map(value => value),
        newGameSessionProtectionPolicy.map(value => value),
        operatingSystem.map(value => value),
        resourceCreationLimitPolicy.map(value => value.asEditable),
        metricGroups.map(value => value),
        stoppedActions.map(value => value),
        instanceRoleArn.map(value => value),
        certificateConfiguration.map(value => value.asEditable)
      )
    def fleetId: Optional[FleetId]
    def fleetArn: Optional[FleetArn]
    def fleetType: Optional[zio.aws.gamelift.model.FleetType]
    def instanceType: Optional[zio.aws.gamelift.model.EC2InstanceType]
    def description: Optional[NonZeroAndMaxString]
    def name: Optional[NonZeroAndMaxString]
    def creationTime: Optional[Timestamp]
    def terminationTime: Optional[Timestamp]
    def status: Optional[zio.aws.gamelift.model.FleetStatus]
    def buildId: Optional[BuildId]
    def buildArn: Optional[BuildArn]
    def scriptId: Optional[ScriptId]
    def scriptArn: Optional[ScriptArn]
    def serverLaunchPath: Optional[LaunchPathStringModel]
    def serverLaunchParameters: Optional[LaunchParametersStringModel]
    def logPaths: Optional[List[NonZeroAndMaxString]]
    def newGameSessionProtectionPolicy
        : Optional[zio.aws.gamelift.model.ProtectionPolicy]
    def operatingSystem: Optional[zio.aws.gamelift.model.OperatingSystem]
    def resourceCreationLimitPolicy
        : Optional[zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly]
    def metricGroups: Optional[List[MetricGroup]]
    def stoppedActions: Optional[List[zio.aws.gamelift.model.FleetAction]]
    def instanceRoleArn: Optional[NonEmptyString]
    def certificateConfiguration
        : Optional[zio.aws.gamelift.model.CertificateConfiguration.ReadOnly]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getFleetType: ZIO[Any, AwsError, zio.aws.gamelift.model.FleetType] =
      AwsError.unwrapOptionField("fleetType", fleetType)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.gamelift.model.EC2InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getDescription: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTerminationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("terminationTime", terminationTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.gamelift.model.FleetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getBuildId: ZIO[Any, AwsError, BuildId] =
      AwsError.unwrapOptionField("buildId", buildId)
    def getBuildArn: ZIO[Any, AwsError, BuildArn] =
      AwsError.unwrapOptionField("buildArn", buildArn)
    def getScriptId: ZIO[Any, AwsError, ScriptId] =
      AwsError.unwrapOptionField("scriptId", scriptId)
    def getScriptArn: ZIO[Any, AwsError, ScriptArn] =
      AwsError.unwrapOptionField("scriptArn", scriptArn)
    def getServerLaunchPath: ZIO[Any, AwsError, LaunchPathStringModel] =
      AwsError.unwrapOptionField("serverLaunchPath", serverLaunchPath)
    def getServerLaunchParameters
        : ZIO[Any, AwsError, LaunchParametersStringModel] = AwsError
      .unwrapOptionField("serverLaunchParameters", serverLaunchParameters)
    def getLogPaths: ZIO[Any, AwsError, List[NonZeroAndMaxString]] =
      AwsError.unwrapOptionField("logPaths", logPaths)
    def getNewGameSessionProtectionPolicy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ProtectionPolicy] =
      AwsError.unwrapOptionField(
        "newGameSessionProtectionPolicy",
        newGameSessionProtectionPolicy
      )
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.gamelift.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getResourceCreationLimitPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceCreationLimitPolicy",
      resourceCreationLimitPolicy
    )
    def getMetricGroups: ZIO[Any, AwsError, List[MetricGroup]] =
      AwsError.unwrapOptionField("metricGroups", metricGroups)
    def getStoppedActions
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.FleetAction]] =
      AwsError.unwrapOptionField("stoppedActions", stoppedActions)
    def getInstanceRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceRoleArn", instanceRoleArn)
    def getCertificateConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.CertificateConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "certificateConfiguration",
      certificateConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.FleetAttributes
  ) extends zio.aws.gamelift.model.FleetAttributes.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val fleetType: Optional[zio.aws.gamelift.model.FleetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetType())
        .map(value => zio.aws.gamelift.model.FleetType.wrap(value))
    override val instanceType
        : Optional[zio.aws.gamelift.model.EC2InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.gamelift.model.EC2InstanceType.wrap(value))
    override val description: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val name: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val terminationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.terminationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val status: Optional[zio.aws.gamelift.model.FleetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.gamelift.model.FleetStatus.wrap(value))
    override val buildId: Optional[BuildId] = zio.aws.core.internal
      .optionalFromNullable(impl.buildId())
      .map(value => zio.aws.gamelift.model.primitives.BuildId(value))
    override val buildArn: Optional[BuildArn] = zio.aws.core.internal
      .optionalFromNullable(impl.buildArn())
      .map(value => zio.aws.gamelift.model.primitives.BuildArn(value))
    override val scriptId: Optional[ScriptId] = zio.aws.core.internal
      .optionalFromNullable(impl.scriptId())
      .map(value => zio.aws.gamelift.model.primitives.ScriptId(value))
    override val scriptArn: Optional[ScriptArn] = zio.aws.core.internal
      .optionalFromNullable(impl.scriptArn())
      .map(value => zio.aws.gamelift.model.primitives.ScriptArn(value))
    override val serverLaunchPath: Optional[LaunchPathStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverLaunchPath())
        .map(value =>
          zio.aws.gamelift.model.primitives.LaunchPathStringModel(value)
        )
    override val serverLaunchParameters: Optional[LaunchParametersStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverLaunchParameters())
        .map(value =>
          zio.aws.gamelift.model.primitives.LaunchParametersStringModel(value)
        )
    override val logPaths: Optional[List[NonZeroAndMaxString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logPaths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.primitives.NonZeroAndMaxString(item)
          }.toList
        )
    override val newGameSessionProtectionPolicy
        : Optional[zio.aws.gamelift.model.ProtectionPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newGameSessionProtectionPolicy())
        .map(value => zio.aws.gamelift.model.ProtectionPolicy.wrap(value))
    override val operatingSystem
        : Optional[zio.aws.gamelift.model.OperatingSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value => zio.aws.gamelift.model.OperatingSystem.wrap(value))
    override val resourceCreationLimitPolicy: Optional[
      zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceCreationLimitPolicy())
      .map(value =>
        zio.aws.gamelift.model.ResourceCreationLimitPolicy.wrap(value)
      )
    override val metricGroups: Optional[List[MetricGroup]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.primitives.MetricGroup(item)
          }.toList
        )
    override val stoppedActions
        : Optional[List[zio.aws.gamelift.model.FleetAction]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stoppedActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.FleetAction.wrap(item)
          }.toList
        )
    override val instanceRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceRoleArn())
        .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val certificateConfiguration
        : Optional[zio.aws.gamelift.model.CertificateConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateConfiguration())
        .map(value =>
          zio.aws.gamelift.model.CertificateConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.FleetAttributes
  ): zio.aws.gamelift.model.FleetAttributes.ReadOnly = new Wrapper(impl)
}
