package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait GameServerProtectionPolicy {
  def unwrap: software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy
}
object GameServerProtectionPolicy {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy
  ): zio.aws.gamelift.model.GameServerProtectionPolicy = value match {
    case software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy.NO_PROTECTION =>
      val r = NO_PROTECTION
      r
    case software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy.FULL_PROTECTION =>
      val r = FULL_PROTECTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.GameServerProtectionPolicy {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy =
      software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_PROTECTION
      extends zio.aws.gamelift.model.GameServerProtectionPolicy {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy =
      software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy.NO_PROTECTION
  }
  case object FULL_PROTECTION
      extends zio.aws.gamelift.model.GameServerProtectionPolicy {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy =
      software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy.FULL_PROTECTION
  }
}
