package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  DnsName,
  FleetId,
  PortNumber,
  MatchmakerData,
  FleetArn,
  WholeNumber,
  Timestamp,
  LocationStringModel,
  IpAddress,
  LargeGameSessionData,
  NonZeroAndMaxString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GameSession(
    gameSessionId: Optional[NonZeroAndMaxString] = Optional.Absent,
    name: Optional[NonZeroAndMaxString] = Optional.Absent,
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    terminationTime: Optional[Timestamp] = Optional.Absent,
    currentPlayerSessionCount: Optional[WholeNumber] = Optional.Absent,
    maximumPlayerSessionCount: Optional[WholeNumber] = Optional.Absent,
    status: Optional[zio.aws.gamelift.model.GameSessionStatus] =
      Optional.Absent,
    statusReason: Optional[zio.aws.gamelift.model.GameSessionStatusReason] =
      Optional.Absent,
    gameProperties: Optional[Iterable[zio.aws.gamelift.model.GameProperty]] =
      Optional.Absent,
    ipAddress: Optional[IpAddress] = Optional.Absent,
    dnsName: Optional[DnsName] = Optional.Absent,
    port: Optional[PortNumber] = Optional.Absent,
    playerSessionCreationPolicy: Optional[
      zio.aws.gamelift.model.PlayerSessionCreationPolicy
    ] = Optional.Absent,
    creatorId: Optional[NonZeroAndMaxString] = Optional.Absent,
    gameSessionData: Optional[LargeGameSessionData] = Optional.Absent,
    matchmakerData: Optional[MatchmakerData] = Optional.Absent,
    location: Optional[LocationStringModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameSession = {
    import GameSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameSession
      .builder()
      .optionallyWith(
        gameSessionId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameSessionId)
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        terminationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.terminationTime)
      .optionallyWith(
        currentPlayerSessionCount.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.currentPlayerSessionCount)
      .optionallyWith(
        maximumPlayerSessionCount.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.maximumPlayerSessionCount)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value.unwrap))(_.statusReason)
      .optionallyWith(
        gameProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameProperties)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        dnsName.map(value => DnsName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(port.map(value => PortNumber.unwrap(value): Integer))(
        _.port
      )
      .optionallyWith(playerSessionCreationPolicy.map(value => value.unwrap))(
        _.playerSessionCreationPolicy
      )
      .optionallyWith(
        creatorId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.creatorId)
      .optionallyWith(
        gameSessionData.map(value =>
          LargeGameSessionData.unwrap(value): java.lang.String
        )
      )(_.gameSessionData)
      .optionallyWith(
        matchmakerData.map(value =>
          MatchmakerData.unwrap(value): java.lang.String
        )
      )(_.matchmakerData)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameSession.ReadOnly =
    zio.aws.gamelift.model.GameSession.wrap(buildAwsValue())
}
object GameSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameSession =
      zio.aws.gamelift.model.GameSession(
        gameSessionId.map(value => value),
        name.map(value => value),
        fleetId.map(value => value),
        fleetArn.map(value => value),
        creationTime.map(value => value),
        terminationTime.map(value => value),
        currentPlayerSessionCount.map(value => value),
        maximumPlayerSessionCount.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        gameProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipAddress.map(value => value),
        dnsName.map(value => value),
        port.map(value => value),
        playerSessionCreationPolicy.map(value => value),
        creatorId.map(value => value),
        gameSessionData.map(value => value),
        matchmakerData.map(value => value),
        location.map(value => value)
      )
    def gameSessionId: Optional[NonZeroAndMaxString]
    def name: Optional[NonZeroAndMaxString]
    def fleetId: Optional[FleetId]
    def fleetArn: Optional[FleetArn]
    def creationTime: Optional[Timestamp]
    def terminationTime: Optional[Timestamp]
    def currentPlayerSessionCount: Optional[WholeNumber]
    def maximumPlayerSessionCount: Optional[WholeNumber]
    def status: Optional[zio.aws.gamelift.model.GameSessionStatus]
    def statusReason: Optional[zio.aws.gamelift.model.GameSessionStatusReason]
    def gameProperties
        : Optional[List[zio.aws.gamelift.model.GameProperty.ReadOnly]]
    def ipAddress: Optional[IpAddress]
    def dnsName: Optional[DnsName]
    def port: Optional[PortNumber]
    def playerSessionCreationPolicy
        : Optional[zio.aws.gamelift.model.PlayerSessionCreationPolicy]
    def creatorId: Optional[NonZeroAndMaxString]
    def gameSessionData: Optional[LargeGameSessionData]
    def matchmakerData: Optional[MatchmakerData]
    def location: Optional[LocationStringModel]
    def getGameSessionId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameSessionId", gameSessionId)
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTerminationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("terminationTime", terminationTime)
    def getCurrentPlayerSessionCount: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("currentPlayerSessionCount", currentPlayerSessionCount)
    def getMaximumPlayerSessionCount: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("maximumPlayerSessionCount", maximumPlayerSessionCount)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameSessionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameSessionStatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getGameProperties: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("gameProperties", gameProperties)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getDnsName: ZIO[Any, AwsError, DnsName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("port", port)
    def getPlayerSessionCreationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.PlayerSessionCreationPolicy
    ] = AwsError.unwrapOptionField(
      "playerSessionCreationPolicy",
      playerSessionCreationPolicy
    )
    def getCreatorId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("creatorId", creatorId)
    def getGameSessionData: ZIO[Any, AwsError, LargeGameSessionData] =
      AwsError.unwrapOptionField("gameSessionData", gameSessionData)
    def getMatchmakerData: ZIO[Any, AwsError, MatchmakerData] =
      AwsError.unwrapOptionField("matchmakerData", matchmakerData)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameSession
  ) extends zio.aws.gamelift.model.GameSession.ReadOnly {
    override val gameSessionId: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionId())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val name: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val terminationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.terminationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val currentPlayerSessionCount: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentPlayerSessionCount())
        .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val maximumPlayerSessionCount: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumPlayerSessionCount())
        .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val status: Optional[zio.aws.gamelift.model.GameSessionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.gamelift.model.GameSessionStatus.wrap(value))
    override val statusReason
        : Optional[zio.aws.gamelift.model.GameSessionStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value =>
          zio.aws.gamelift.model.GameSessionStatusReason.wrap(value)
        )
    override val gameProperties
        : Optional[List[zio.aws.gamelift.model.GameProperty.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.GameProperty.wrap(item)
          }.toList
        )
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.gamelift.model.primitives.IpAddress(value))
    override val dnsName: Optional[DnsName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.gamelift.model.primitives.DnsName(value))
    override val port: Optional[PortNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.gamelift.model.primitives.PortNumber(value))
    override val playerSessionCreationPolicy
        : Optional[zio.aws.gamelift.model.PlayerSessionCreationPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playerSessionCreationPolicy())
        .map(value =>
          zio.aws.gamelift.model.PlayerSessionCreationPolicy.wrap(value)
        )
    override val creatorId: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creatorId())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val gameSessionData: Optional[LargeGameSessionData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionData())
        .map(value =>
          zio.aws.gamelift.model.primitives.LargeGameSessionData(value)
        )
    override val matchmakerData: Optional[MatchmakerData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.matchmakerData())
        .map(value => zio.aws.gamelift.model.primitives.MatchmakerData(value))
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameSession
  ): zio.aws.gamelift.model.GameSession.ReadOnly = new Wrapper(impl)
}
