package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GameSessionDetail(
    gameSession: Optional[zio.aws.gamelift.model.GameSession] = Optional.Absent,
    protectionPolicy: Optional[zio.aws.gamelift.model.ProtectionPolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameSessionDetail = {
    import GameSessionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameSessionDetail
      .builder()
      .optionallyWith(gameSession.map(value => value.buildAwsValue()))(
        _.gameSession
      )
      .optionallyWith(protectionPolicy.map(value => value.unwrap))(
        _.protectionPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameSessionDetail.ReadOnly =
    zio.aws.gamelift.model.GameSessionDetail.wrap(buildAwsValue())
}
object GameSessionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameSessionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameSessionDetail =
      zio.aws.gamelift.model.GameSessionDetail(
        gameSession.map(value => value.asEditable),
        protectionPolicy.map(value => value)
      )
    def gameSession: Optional[zio.aws.gamelift.model.GameSession.ReadOnly]
    def protectionPolicy: Optional[zio.aws.gamelift.model.ProtectionPolicy]
    def getGameSession
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameSession.ReadOnly] =
      AwsError.unwrapOptionField("gameSession", gameSession)
    def getProtectionPolicy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ProtectionPolicy] =
      AwsError.unwrapOptionField("protectionPolicy", protectionPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionDetail
  ) extends zio.aws.gamelift.model.GameSessionDetail.ReadOnly {
    override val gameSession
        : Optional[zio.aws.gamelift.model.GameSession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSession())
        .map(value => zio.aws.gamelift.model.GameSession.wrap(value))
    override val protectionPolicy
        : Optional[zio.aws.gamelift.model.ProtectionPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protectionPolicy())
        .map(value => zio.aws.gamelift.model.ProtectionPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionDetail
  ): zio.aws.gamelift.model.GameSessionDetail.ReadOnly = new Wrapper(impl)
}
