package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait GameSessionStatus {
  def unwrap: software.amazon.awssdk.services.gamelift.model.GameSessionStatus
}
object GameSessionStatus {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.GameSessionStatus
  ): zio.aws.gamelift.model.GameSessionStatus = value match {
    case software.amazon.awssdk.services.gamelift.model.GameSessionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.GameSessionStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.gamelift.model.GameSessionStatus.ACTIVATING =>
      val r = ACTIVATING
      r
    case software.amazon.awssdk.services.gamelift.model.GameSessionStatus.TERMINATED =>
      val r = TERMINATED
      r
    case software.amazon.awssdk.services.gamelift.model.GameSessionStatus.TERMINATING =>
      val r = TERMINATING
      r
    case software.amazon.awssdk.services.gamelift.model.GameSessionStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.GameSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionStatus =
      software.amazon.awssdk.services.gamelift.model.GameSessionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.gamelift.model.GameSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionStatus =
      software.amazon.awssdk.services.gamelift.model.GameSessionStatus.ACTIVE
  }
  case object ACTIVATING extends zio.aws.gamelift.model.GameSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionStatus =
      software.amazon.awssdk.services.gamelift.model.GameSessionStatus.ACTIVATING
  }
  case object TERMINATED extends zio.aws.gamelift.model.GameSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionStatus =
      software.amazon.awssdk.services.gamelift.model.GameSessionStatus.TERMINATED
  }
  case object TERMINATING extends zio.aws.gamelift.model.GameSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionStatus =
      software.amazon.awssdk.services.gamelift.model.GameSessionStatus.TERMINATING
  }
  case object ERROR extends zio.aws.gamelift.model.GameSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionStatus =
      software.amazon.awssdk.services.gamelift.model.GameSessionStatus.ERROR
  }
}
