package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.LocationStringModel
import scala.jdk.CollectionConverters._
final case class LocationState(
    location: Optional[LocationStringModel] = Optional.Absent,
    status: Optional[zio.aws.gamelift.model.FleetStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.LocationState = {
    import LocationState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.LocationState
      .builder()
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.LocationState.ReadOnly =
    zio.aws.gamelift.model.LocationState.wrap(buildAwsValue())
}
object LocationState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.LocationState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.LocationState =
      zio.aws.gamelift.model
        .LocationState(location.map(value => value), status.map(value => value))
    def location: Optional[LocationStringModel]
    def status: Optional[zio.aws.gamelift.model.FleetStatus]
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
    def getStatus: ZIO[Any, AwsError, zio.aws.gamelift.model.FleetStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.LocationState
  ) extends zio.aws.gamelift.model.LocationState.ReadOnly {
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
    override val status: Optional[zio.aws.gamelift.model.FleetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.gamelift.model.FleetStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.LocationState
  ): zio.aws.gamelift.model.LocationState.ReadOnly = new Wrapper(impl)
}
