package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  Timestamp,
  RuleSetBody,
  MatchmakingRuleSetArn,
  MatchmakingIdStringModel
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class MatchmakingRuleSet(
    ruleSetName: Optional[MatchmakingIdStringModel] = Optional.Absent,
    ruleSetArn: Optional[MatchmakingRuleSetArn] = Optional.Absent,
    ruleSetBody: RuleSetBody,
    creationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.MatchmakingRuleSet = {
    import MatchmakingRuleSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.MatchmakingRuleSet
      .builder()
      .optionallyWith(
        ruleSetName.map(value =>
          MatchmakingIdStringModel.unwrap(value): java.lang.String
        )
      )(_.ruleSetName)
      .optionallyWith(
        ruleSetArn.map(value =>
          MatchmakingRuleSetArn.unwrap(value): java.lang.String
        )
      )(_.ruleSetArn)
      .ruleSetBody(RuleSetBody.unwrap(ruleSetBody): java.lang.String)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.MatchmakingRuleSet.ReadOnly =
    zio.aws.gamelift.model.MatchmakingRuleSet.wrap(buildAwsValue())
}
object MatchmakingRuleSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.MatchmakingRuleSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.MatchmakingRuleSet =
      zio.aws.gamelift.model.MatchmakingRuleSet(
        ruleSetName.map(value => value),
        ruleSetArn.map(value => value),
        ruleSetBody,
        creationTime.map(value => value)
      )
    def ruleSetName: Optional[MatchmakingIdStringModel]
    def ruleSetArn: Optional[MatchmakingRuleSetArn]
    def ruleSetBody: RuleSetBody
    def creationTime: Optional[Timestamp]
    def getRuleSetName: ZIO[Any, AwsError, MatchmakingIdStringModel] =
      AwsError.unwrapOptionField("ruleSetName", ruleSetName)
    def getRuleSetArn: ZIO[Any, AwsError, MatchmakingRuleSetArn] =
      AwsError.unwrapOptionField("ruleSetArn", ruleSetArn)
    def getRuleSetBody: ZIO[Any, Nothing, RuleSetBody] =
      ZIO.succeed(ruleSetBody)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.MatchmakingRuleSet
  ) extends zio.aws.gamelift.model.MatchmakingRuleSet.ReadOnly {
    override val ruleSetName: Optional[MatchmakingIdStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleSetName())
        .map(value =>
          zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(value)
        )
    override val ruleSetArn: Optional[MatchmakingRuleSetArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleSetArn())
        .map(value =>
          zio.aws.gamelift.model.primitives.MatchmakingRuleSetArn(value)
        )
    override val ruleSetBody: RuleSetBody =
      zio.aws.gamelift.model.primitives.RuleSetBody(impl.ruleSetBody())
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.MatchmakingRuleSet
  ): zio.aws.gamelift.model.MatchmakingRuleSet.ReadOnly = new Wrapper(impl)
}
