package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{PlayerSessionId, NonZeroAndMaxString}
import scala.jdk.CollectionConverters._
final case class PlacedPlayerSession(
    playerId: Optional[NonZeroAndMaxString] = Optional.Absent,
    playerSessionId: Optional[PlayerSessionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.PlacedPlayerSession = {
    import PlacedPlayerSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.PlacedPlayerSession
      .builder()
      .optionallyWith(
        playerId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.playerId)
      .optionallyWith(
        playerSessionId.map(value =>
          PlayerSessionId.unwrap(value): java.lang.String
        )
      )(_.playerSessionId)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.PlacedPlayerSession.ReadOnly =
    zio.aws.gamelift.model.PlacedPlayerSession.wrap(buildAwsValue())
}
object PlacedPlayerSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.PlacedPlayerSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.PlacedPlayerSession =
      zio.aws.gamelift.model.PlacedPlayerSession(
        playerId.map(value => value),
        playerSessionId.map(value => value)
      )
    def playerId: Optional[NonZeroAndMaxString]
    def playerSessionId: Optional[PlayerSessionId]
    def getPlayerId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("playerId", playerId)
    def getPlayerSessionId: ZIO[Any, AwsError, PlayerSessionId] =
      AwsError.unwrapOptionField("playerSessionId", playerSessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.PlacedPlayerSession
  ) extends zio.aws.gamelift.model.PlacedPlayerSession.ReadOnly {
    override val playerId: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.playerId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val playerSessionId: Optional[PlayerSessionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playerSessionId())
        .map(value => zio.aws.gamelift.model.primitives.PlayerSessionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.PlacedPlayerSession
  ): zio.aws.gamelift.model.PlacedPlayerSession.ReadOnly = new Wrapper(impl)
}
