package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.WholeNumber
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PlayerLatencyPolicy(
    maximumIndividualPlayerLatencyMilliseconds: Optional[WholeNumber] =
      Optional.Absent,
    policyDurationSeconds: Optional[WholeNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy = {
    import PlayerLatencyPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy
      .builder()
      .optionallyWith(
        maximumIndividualPlayerLatencyMilliseconds.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.maximumIndividualPlayerLatencyMilliseconds)
      .optionallyWith(
        policyDurationSeconds.map(value => WholeNumber.unwrap(value): Integer)
      )(_.policyDurationSeconds)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.PlayerLatencyPolicy.ReadOnly =
    zio.aws.gamelift.model.PlayerLatencyPolicy.wrap(buildAwsValue())
}
object PlayerLatencyPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.PlayerLatencyPolicy =
      zio.aws.gamelift.model.PlayerLatencyPolicy(
        maximumIndividualPlayerLatencyMilliseconds.map(value => value),
        policyDurationSeconds.map(value => value)
      )
    def maximumIndividualPlayerLatencyMilliseconds: Optional[WholeNumber]
    def policyDurationSeconds: Optional[WholeNumber]
    def getMaximumIndividualPlayerLatencyMilliseconds
        : ZIO[Any, AwsError, WholeNumber] = AwsError.unwrapOptionField(
      "maximumIndividualPlayerLatencyMilliseconds",
      maximumIndividualPlayerLatencyMilliseconds
    )
    def getPolicyDurationSeconds: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("policyDurationSeconds", policyDurationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy
  ) extends zio.aws.gamelift.model.PlayerLatencyPolicy.ReadOnly {
    override val maximumIndividualPlayerLatencyMilliseconds
        : Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumIndividualPlayerLatencyMilliseconds())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val policyDurationSeconds: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDurationSeconds())
        .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy
  ): zio.aws.gamelift.model.PlayerLatencyPolicy.ReadOnly = new Wrapper(impl)
}
