package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.LocationStringModel
import scala.jdk.CollectionConverters._
final case class PriorityConfiguration(
    priorityOrder: Optional[Iterable[zio.aws.gamelift.model.PriorityType]] =
      Optional.Absent,
    locationOrder: Optional[Iterable[LocationStringModel]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.PriorityConfiguration = {
    import PriorityConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.PriorityConfiguration
      .builder()
      .optionallyWith(
        priorityOrder.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.priorityOrderWithStrings)
      .optionallyWith(
        locationOrder.map(value =>
          value.map { item =>
            LocationStringModel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.locationOrder)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.PriorityConfiguration.ReadOnly =
    zio.aws.gamelift.model.PriorityConfiguration.wrap(buildAwsValue())
}
object PriorityConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.PriorityConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.PriorityConfiguration =
      zio.aws.gamelift.model.PriorityConfiguration(
        priorityOrder.map(value => value),
        locationOrder.map(value => value)
      )
    def priorityOrder: Optional[List[zio.aws.gamelift.model.PriorityType]]
    def locationOrder: Optional[List[LocationStringModel]]
    def getPriorityOrder
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.PriorityType]] =
      AwsError.unwrapOptionField("priorityOrder", priorityOrder)
    def getLocationOrder: ZIO[Any, AwsError, List[LocationStringModel]] =
      AwsError.unwrapOptionField("locationOrder", locationOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.PriorityConfiguration
  ) extends zio.aws.gamelift.model.PriorityConfiguration.ReadOnly {
    override val priorityOrder
        : Optional[List[zio.aws.gamelift.model.PriorityType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priorityOrder())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.PriorityType.wrap(item)
          }.toList
        )
    override val locationOrder: Optional[List[LocationStringModel]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationOrder())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.primitives.LocationStringModel(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.PriorityConfiguration
  ): zio.aws.gamelift.model.PriorityConfiguration.ReadOnly = new Wrapper(impl)
}
