package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class PutScalingPolicyResponse(
    name: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.PutScalingPolicyResponse = {
    import PutScalingPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.PutScalingPolicyResponse
      .builder()
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.PutScalingPolicyResponse.ReadOnly =
    zio.aws.gamelift.model.PutScalingPolicyResponse.wrap(buildAwsValue())
}
object PutScalingPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.PutScalingPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.PutScalingPolicyResponse =
      zio.aws.gamelift.model.PutScalingPolicyResponse(name.map(value => value))
    def name: Optional[NonZeroAndMaxString]
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.PutScalingPolicyResponse
  ) extends zio.aws.gamelift.model.PutScalingPolicyResponse.ReadOnly {
    override val name: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.PutScalingPolicyResponse
  ): zio.aws.gamelift.model.PutScalingPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
