package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  WholeNumber,
  IdStringModel,
  LargeGameSessionData,
  NonZeroAndMaxString,
  GameSessionQueueNameOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StartGameSessionPlacementRequest(
    placementId: IdStringModel,
    gameSessionQueueName: GameSessionQueueNameOrArn,
    gameProperties: Optional[Iterable[zio.aws.gamelift.model.GameProperty]] =
      Optional.Absent,
    maximumPlayerSessionCount: WholeNumber,
    gameSessionName: Optional[NonZeroAndMaxString] = Optional.Absent,
    playerLatencies: Optional[Iterable[zio.aws.gamelift.model.PlayerLatency]] =
      Optional.Absent,
    desiredPlayerSessions: Optional[
      Iterable[zio.aws.gamelift.model.DesiredPlayerSession]
    ] = Optional.Absent,
    gameSessionData: Optional[LargeGameSessionData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest = {
    import StartGameSessionPlacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest
      .builder()
      .placementId(IdStringModel.unwrap(placementId): java.lang.String)
      .gameSessionQueueName(
        GameSessionQueueNameOrArn.unwrap(gameSessionQueueName): java.lang.String
      )
      .optionallyWith(
        gameProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameProperties)
      .maximumPlayerSessionCount(
        WholeNumber.unwrap(maximumPlayerSessionCount): Integer
      )
      .optionallyWith(
        gameSessionName.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameSessionName)
      .optionallyWith(
        playerLatencies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.playerLatencies)
      .optionallyWith(
        desiredPlayerSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.desiredPlayerSessions)
      .optionallyWith(
        gameSessionData.map(value =>
          LargeGameSessionData.unwrap(value): java.lang.String
        )
      )(_.gameSessionData)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.StartGameSessionPlacementRequest.ReadOnly =
    zio.aws.gamelift.model.StartGameSessionPlacementRequest
      .wrap(buildAwsValue())
}
object StartGameSessionPlacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StartGameSessionPlacementRequest =
      zio.aws.gamelift.model.StartGameSessionPlacementRequest(
        placementId,
        gameSessionQueueName,
        gameProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maximumPlayerSessionCount,
        gameSessionName.map(value => value),
        playerLatencies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        desiredPlayerSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gameSessionData.map(value => value)
      )
    def placementId: IdStringModel
    def gameSessionQueueName: GameSessionQueueNameOrArn
    def gameProperties
        : Optional[List[zio.aws.gamelift.model.GameProperty.ReadOnly]]
    def maximumPlayerSessionCount: WholeNumber
    def gameSessionName: Optional[NonZeroAndMaxString]
    def playerLatencies
        : Optional[List[zio.aws.gamelift.model.PlayerLatency.ReadOnly]]
    def desiredPlayerSessions
        : Optional[List[zio.aws.gamelift.model.DesiredPlayerSession.ReadOnly]]
    def gameSessionData: Optional[LargeGameSessionData]
    def getPlacementId: ZIO[Any, Nothing, IdStringModel] =
      ZIO.succeed(placementId)
    def getGameSessionQueueName: ZIO[Any, Nothing, GameSessionQueueNameOrArn] =
      ZIO.succeed(gameSessionQueueName)
    def getGameProperties: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("gameProperties", gameProperties)
    def getMaximumPlayerSessionCount: ZIO[Any, Nothing, WholeNumber] =
      ZIO.succeed(maximumPlayerSessionCount)
    def getGameSessionName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameSessionName", gameSessionName)
    def getPlayerLatencies: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.PlayerLatency.ReadOnly
    ]] = AwsError.unwrapOptionField("playerLatencies", playerLatencies)
    def getDesiredPlayerSessions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.DesiredPlayerSession.ReadOnly
    ]] =
      AwsError.unwrapOptionField("desiredPlayerSessions", desiredPlayerSessions)
    def getGameSessionData: ZIO[Any, AwsError, LargeGameSessionData] =
      AwsError.unwrapOptionField("gameSessionData", gameSessionData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest
  ) extends zio.aws.gamelift.model.StartGameSessionPlacementRequest.ReadOnly {
    override val placementId: IdStringModel =
      zio.aws.gamelift.model.primitives.IdStringModel(impl.placementId())
    override val gameSessionQueueName: GameSessionQueueNameOrArn =
      zio.aws.gamelift.model.primitives
        .GameSessionQueueNameOrArn(impl.gameSessionQueueName())
    override val gameProperties
        : Optional[List[zio.aws.gamelift.model.GameProperty.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.GameProperty.wrap(item)
          }.toList
        )
    override val maximumPlayerSessionCount: WholeNumber =
      zio.aws.gamelift.model.primitives
        .WholeNumber(impl.maximumPlayerSessionCount())
    override val gameSessionName: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionName())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val playerLatencies
        : Optional[List[zio.aws.gamelift.model.PlayerLatency.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playerLatencies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.PlayerLatency.wrap(item)
          }.toList
        )
    override val desiredPlayerSessions
        : Optional[List[zio.aws.gamelift.model.DesiredPlayerSession.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredPlayerSessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.DesiredPlayerSession.wrap(item)
          }.toList
        )
    override val gameSessionData: Optional[LargeGameSessionData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionData())
        .map(value =>
          zio.aws.gamelift.model.primitives.LargeGameSessionData(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest
  ): zio.aws.gamelift.model.StartGameSessionPlacementRequest.ReadOnly =
    new Wrapper(impl)
}
