package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.IdStringModel
import scala.jdk.CollectionConverters._
final case class StopGameSessionPlacementRequest(placementId: IdStringModel) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementRequest = {
    import StopGameSessionPlacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementRequest
      .builder()
      .placementId(IdStringModel.unwrap(placementId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.StopGameSessionPlacementRequest.ReadOnly =
    zio.aws.gamelift.model.StopGameSessionPlacementRequest.wrap(buildAwsValue())
}
object StopGameSessionPlacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StopGameSessionPlacementRequest =
      zio.aws.gamelift.model.StopGameSessionPlacementRequest(placementId)
    def placementId: IdStringModel
    def getPlacementId: ZIO[Any, Nothing, IdStringModel] =
      ZIO.succeed(placementId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementRequest
  ) extends zio.aws.gamelift.model.StopGameSessionPlacementRequest.ReadOnly {
    override val placementId: IdStringModel =
      zio.aws.gamelift.model.primitives.IdStringModel(impl.placementId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementRequest
  ): zio.aws.gamelift.model.StopGameSessionPlacementRequest.ReadOnly =
    new Wrapper(impl)
}
