package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.FleetId
import scala.jdk.CollectionConverters._
final case class UpdateFleetPortSettingsResponse(
    fleetId: Optional[FleetId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse = {
    import UpdateFleetPortSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.wrap(buildAwsValue())
}
object UpdateFleetPortSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateFleetPortSettingsResponse =
      zio.aws.gamelift.model
        .UpdateFleetPortSettingsResponse(fleetId.map(value => value))
    def fleetId: Optional[FleetId]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse
  ) extends zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse
  ): zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
