package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  GameServerData,
  GameServerId,
  GameServerGroupNameOrArn
}
import scala.jdk.CollectionConverters._
final case class UpdateGameServerRequest(
    gameServerGroupName: GameServerGroupNameOrArn,
    gameServerId: GameServerId,
    gameServerData: Optional[GameServerData] = Optional.Absent,
    utilizationStatus: Optional[
      zio.aws.gamelift.model.GameServerUtilizationStatus
    ] = Optional.Absent,
    healthCheck: Optional[zio.aws.gamelift.model.GameServerHealthCheck] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateGameServerRequest = {
    import UpdateGameServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateGameServerRequest
      .builder()
      .gameServerGroupName(
        GameServerGroupNameOrArn.unwrap(gameServerGroupName): java.lang.String
      )
      .gameServerId(GameServerId.unwrap(gameServerId): java.lang.String)
      .optionallyWith(
        gameServerData.map(value =>
          GameServerData.unwrap(value): java.lang.String
        )
      )(_.gameServerData)
      .optionallyWith(utilizationStatus.map(value => value.unwrap))(
        _.utilizationStatus
      )
      .optionallyWith(healthCheck.map(value => value.unwrap))(_.healthCheck)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateGameServerRequest.ReadOnly =
    zio.aws.gamelift.model.UpdateGameServerRequest.wrap(buildAwsValue())
}
object UpdateGameServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateGameServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateGameServerRequest =
      zio.aws.gamelift.model.UpdateGameServerRequest(
        gameServerGroupName,
        gameServerId,
        gameServerData.map(value => value),
        utilizationStatus.map(value => value),
        healthCheck.map(value => value)
      )
    def gameServerGroupName: GameServerGroupNameOrArn
    def gameServerId: GameServerId
    def gameServerData: Optional[GameServerData]
    def utilizationStatus
        : Optional[zio.aws.gamelift.model.GameServerUtilizationStatus]
    def healthCheck: Optional[zio.aws.gamelift.model.GameServerHealthCheck]
    def getGameServerGroupName: ZIO[Any, Nothing, GameServerGroupNameOrArn] =
      ZIO.succeed(gameServerGroupName)
    def getGameServerId: ZIO[Any, Nothing, GameServerId] =
      ZIO.succeed(gameServerId)
    def getGameServerData: ZIO[Any, AwsError, GameServerData] =
      AwsError.unwrapOptionField("gameServerData", gameServerData)
    def getUtilizationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameServerUtilizationStatus
    ] = AwsError.unwrapOptionField("utilizationStatus", utilizationStatus)
    def getHealthCheck
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServerHealthCheck] =
      AwsError.unwrapOptionField("healthCheck", healthCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameServerRequest
  ) extends zio.aws.gamelift.model.UpdateGameServerRequest.ReadOnly {
    override val gameServerGroupName: GameServerGroupNameOrArn =
      zio.aws.gamelift.model.primitives
        .GameServerGroupNameOrArn(impl.gameServerGroupName())
    override val gameServerId: GameServerId =
      zio.aws.gamelift.model.primitives.GameServerId(impl.gameServerId())
    override val gameServerData: Optional[GameServerData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerData())
        .map(value => zio.aws.gamelift.model.primitives.GameServerData(value))
    override val utilizationStatus
        : Optional[zio.aws.gamelift.model.GameServerUtilizationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.utilizationStatus())
        .map(value =>
          zio.aws.gamelift.model.GameServerUtilizationStatus.wrap(value)
        )
    override val healthCheck
        : Optional[zio.aws.gamelift.model.GameServerHealthCheck] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheck())
        .map(value => zio.aws.gamelift.model.GameServerHealthCheck.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameServerRequest
  ): zio.aws.gamelift.model.UpdateGameServerRequest.ReadOnly = new Wrapper(impl)
}
