package zio.aws.gamelift
import zio.aws.gamelift.model.primitives.GamePropertyKey.Type
import zio.aws.gamelift.model.primitives.{
  DoubleObject,
  ArnStringModel,
  FleetId,
  FleetIdOrArn,
  PositiveInteger,
  LocationStringModel,
  MetricGroup,
  PlayerData,
  NonZeroAndMaxString,
  MatchmakingConfigurationName,
  GameServerInstanceId,
  GameSessionQueueNameOrArn,
  MatchmakingIdStringModel,
  VpcSubnet,
  NonEmptyString,
  MatchmakingRuleSetName,
  TagKey
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AliasArn extends Subtype[String]
    type AliasArn = zio.aws.gamelift.model.primitives.AliasArn.Type
    object AliasId extends Subtype[String]
    type AliasId = zio.aws.gamelift.model.primitives.AliasId.Type
    object AliasIdOrArn extends Subtype[String]
    type AliasIdOrArn = zio.aws.gamelift.model.primitives.AliasIdOrArn.Type
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.gamelift.model.primitives.AmazonResourceName.Type
    object ArnStringModel extends Subtype[String]
    type ArnStringModel = zio.aws.gamelift.model.primitives.ArnStringModel.Type
    object AutoScalingGroupArn extends Subtype[String]
    type AutoScalingGroupArn =
      zio.aws.gamelift.model.primitives.AutoScalingGroupArn.Type
    object BooleanModel extends Subtype[Boolean]
    type BooleanModel = zio.aws.gamelift.model.primitives.BooleanModel.Type
    object BuildArn extends Subtype[String]
    type BuildArn = zio.aws.gamelift.model.primitives.BuildArn.Type
    object BuildId extends Subtype[String]
    type BuildId = zio.aws.gamelift.model.primitives.BuildId.Type
    object BuildIdOrArn extends Subtype[String]
    type BuildIdOrArn = zio.aws.gamelift.model.primitives.BuildIdOrArn.Type
    object CustomEventData extends Subtype[String]
    type CustomEventData =
      zio.aws.gamelift.model.primitives.CustomEventData.Type
    object DnsName extends Subtype[String]
    type DnsName = zio.aws.gamelift.model.primitives.DnsName.Type
    type DoubleObject = Double
    object FleetArn extends Subtype[String]
    type FleetArn = zio.aws.gamelift.model.primitives.FleetArn.Type
    object FleetId extends Subtype[String]
    type FleetId = zio.aws.gamelift.model.primitives.FleetId.Type
    object FleetIdOrArn extends Subtype[String]
    type FleetIdOrArn = zio.aws.gamelift.model.primitives.FleetIdOrArn.Type
    object FreeText extends Subtype[String]
    type FreeText = zio.aws.gamelift.model.primitives.FreeText.Type
    object GamePropertyKey extends Subtype[String]
    type GamePropertyKey =
      zio.aws.gamelift.model.primitives.GamePropertyKey.Type
    object GamePropertyValue extends Subtype[String]
    type GamePropertyValue =
      zio.aws.gamelift.model.primitives.GamePropertyValue.Type
    object GameServerConnectionInfo extends Subtype[String]
    type GameServerConnectionInfo =
      zio.aws.gamelift.model.primitives.GameServerConnectionInfo.Type
    object GameServerData extends Subtype[String]
    type GameServerData = zio.aws.gamelift.model.primitives.GameServerData.Type
    object GameServerGroupArn extends Subtype[String]
    type GameServerGroupArn =
      zio.aws.gamelift.model.primitives.GameServerGroupArn.Type
    object GameServerGroupName extends Subtype[String]
    type GameServerGroupName =
      zio.aws.gamelift.model.primitives.GameServerGroupName.Type
    object GameServerGroupNameOrArn extends Subtype[String]
    type GameServerGroupNameOrArn =
      zio.aws.gamelift.model.primitives.GameServerGroupNameOrArn.Type
    object GameServerId extends Subtype[String]
    type GameServerId = zio.aws.gamelift.model.primitives.GameServerId.Type
    object GameServerInstanceId extends Subtype[String]
    type GameServerInstanceId =
      zio.aws.gamelift.model.primitives.GameServerInstanceId.Type
    object GameSessionActivationTimeoutSeconds extends Subtype[Int]
    type GameSessionActivationTimeoutSeconds =
      zio.aws.gamelift.model.primitives.GameSessionActivationTimeoutSeconds.Type
    object GameSessionData extends Subtype[String]
    type GameSessionData =
      zio.aws.gamelift.model.primitives.GameSessionData.Type
    object GameSessionQueueArn extends Subtype[String]
    type GameSessionQueueArn =
      zio.aws.gamelift.model.primitives.GameSessionQueueArn.Type
    object GameSessionQueueName extends Subtype[String]
    type GameSessionQueueName =
      zio.aws.gamelift.model.primitives.GameSessionQueueName.Type
    object GameSessionQueueNameOrArn extends Subtype[String]
    type GameSessionQueueNameOrArn =
      zio.aws.gamelift.model.primitives.GameSessionQueueNameOrArn.Type
    object IamRoleArn extends Subtype[String]
    type IamRoleArn = zio.aws.gamelift.model.primitives.IamRoleArn.Type
    object IdStringModel extends Subtype[String]
    type IdStringModel = zio.aws.gamelift.model.primitives.IdStringModel.Type
    object InstanceId extends Subtype[String]
    type InstanceId = zio.aws.gamelift.model.primitives.InstanceId.Type
    type Integer = Int
    object IpAddress extends Subtype[String]
    type IpAddress = zio.aws.gamelift.model.primitives.IpAddress.Type
    object LargeGameSessionData extends Subtype[String]
    type LargeGameSessionData =
      zio.aws.gamelift.model.primitives.LargeGameSessionData.Type
    object LaunchParametersStringModel extends Subtype[String]
    type LaunchParametersStringModel =
      zio.aws.gamelift.model.primitives.LaunchParametersStringModel.Type
    object LaunchPathStringModel extends Subtype[String]
    type LaunchPathStringModel =
      zio.aws.gamelift.model.primitives.LaunchPathStringModel.Type
    object LaunchTemplateId extends Subtype[String]
    type LaunchTemplateId =
      zio.aws.gamelift.model.primitives.LaunchTemplateId.Type
    object LaunchTemplateName extends Subtype[String]
    type LaunchTemplateName =
      zio.aws.gamelift.model.primitives.LaunchTemplateName.Type
    object LaunchTemplateVersion extends Subtype[String]
    type LaunchTemplateVersion =
      zio.aws.gamelift.model.primitives.LaunchTemplateVersion.Type
    object LocationStringModel extends Subtype[String]
    type LocationStringModel =
      zio.aws.gamelift.model.primitives.LocationStringModel.Type
    object MatchmakerData extends Subtype[String]
    type MatchmakerData = zio.aws.gamelift.model.primitives.MatchmakerData.Type
    object MatchmakingAcceptanceTimeoutInteger extends Subtype[Int]
    type MatchmakingAcceptanceTimeoutInteger =
      zio.aws.gamelift.model.primitives.MatchmakingAcceptanceTimeoutInteger.Type
    object MatchmakingConfigurationArn extends Subtype[String]
    type MatchmakingConfigurationArn =
      zio.aws.gamelift.model.primitives.MatchmakingConfigurationArn.Type
    object MatchmakingConfigurationName extends Subtype[String]
    type MatchmakingConfigurationName =
      zio.aws.gamelift.model.primitives.MatchmakingConfigurationName.Type
    object MatchmakingIdStringModel extends Subtype[String]
    type MatchmakingIdStringModel =
      zio.aws.gamelift.model.primitives.MatchmakingIdStringModel.Type
    object MatchmakingRequestTimeoutInteger extends Subtype[Int]
    type MatchmakingRequestTimeoutInteger =
      zio.aws.gamelift.model.primitives.MatchmakingRequestTimeoutInteger.Type
    object MatchmakingRuleSetArn extends Subtype[String]
    type MatchmakingRuleSetArn =
      zio.aws.gamelift.model.primitives.MatchmakingRuleSetArn.Type
    object MatchmakingRuleSetName extends Subtype[String]
    type MatchmakingRuleSetName =
      zio.aws.gamelift.model.primitives.MatchmakingRuleSetName.Type
    object MaxConcurrentGameSessionActivations extends Subtype[Int]
    type MaxConcurrentGameSessionActivations =
      zio.aws.gamelift.model.primitives.MaxConcurrentGameSessionActivations.Type
    object MetricGroup extends Subtype[String]
    type MetricGroup = zio.aws.gamelift.model.primitives.MetricGroup.Type
    object NonBlankAndLengthConstraintString extends Subtype[String]
    type NonBlankAndLengthConstraintString =
      zio.aws.gamelift.model.primitives.NonBlankAndLengthConstraintString.Type
    object NonBlankString extends Subtype[String]
    type NonBlankString = zio.aws.gamelift.model.primitives.NonBlankString.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString = zio.aws.gamelift.model.primitives.NonEmptyString.Type
    object NonNegativeDouble extends Subtype[Double]
    type NonNegativeDouble =
      zio.aws.gamelift.model.primitives.NonNegativeDouble.Type
    object NonZeroAndMaxString extends Subtype[String]
    type NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives.NonZeroAndMaxString.Type
    object PlayerData extends Subtype[String]
    type PlayerData = zio.aws.gamelift.model.primitives.PlayerData.Type
    object PlayerSessionId extends Subtype[String]
    type PlayerSessionId =
      zio.aws.gamelift.model.primitives.PlayerSessionId.Type
    object PortNumber extends Subtype[Int]
    type PortNumber = zio.aws.gamelift.model.primitives.PortNumber.Type
    object PositiveInteger extends Subtype[Int]
    type PositiveInteger =
      zio.aws.gamelift.model.primitives.PositiveInteger.Type
    object PositiveLong extends Subtype[Long]
    type PositiveLong = zio.aws.gamelift.model.primitives.PositiveLong.Type
    object QueueCustomEventData extends Subtype[String]
    type QueueCustomEventData =
      zio.aws.gamelift.model.primitives.QueueCustomEventData.Type
    object QueueSnsArnStringModel extends Subtype[String]
    type QueueSnsArnStringModel =
      zio.aws.gamelift.model.primitives.QueueSnsArnStringModel.Type
    object RuleSetBody extends Subtype[String]
    type RuleSetBody = zio.aws.gamelift.model.primitives.RuleSetBody.Type
    object RuleSetLimit extends Subtype[Int]
    type RuleSetLimit = zio.aws.gamelift.model.primitives.RuleSetLimit.Type
    object ScriptArn extends Subtype[String]
    type ScriptArn = zio.aws.gamelift.model.primitives.ScriptArn.Type
    object ScriptId extends Subtype[String]
    type ScriptId = zio.aws.gamelift.model.primitives.ScriptId.Type
    object ScriptIdOrArn extends Subtype[String]
    type ScriptIdOrArn = zio.aws.gamelift.model.primitives.ScriptIdOrArn.Type
    object SnsArnStringModel extends Subtype[String]
    type SnsArnStringModel =
      zio.aws.gamelift.model.primitives.SnsArnStringModel.Type
    object StringModel extends Subtype[String]
    type StringModel = zio.aws.gamelift.model.primitives.StringModel.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.gamelift.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.gamelift.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.gamelift.model.primitives.Timestamp.Type
    object VpcSubnet extends Subtype[String]
    type VpcSubnet = zio.aws.gamelift.model.primitives.VpcSubnet.Type
    object WeightedCapacity extends Subtype[String]
    type WeightedCapacity =
      zio.aws.gamelift.model.primitives.WeightedCapacity.Type
    object WholeNumber extends Subtype[Int]
    type WholeNumber = zio.aws.gamelift.model.primitives.WholeNumber.Type
    object ZipBlob extends Subtype[Chunk[Byte]]
    type ZipBlob = zio.aws.gamelift.model.primitives.ZipBlob.Type
  }
  type AliasList = List[zio.aws.gamelift.model.Alias]
  type BuildList = List[zio.aws.gamelift.model.Build]
  type DesiredPlayerSessionList =
    List[zio.aws.gamelift.model.DesiredPlayerSession]
  type EC2InstanceLimitList = List[zio.aws.gamelift.model.EC2InstanceLimit]
  type EventList = List[zio.aws.gamelift.model.Event]
  type FleetActionList = List[zio.aws.gamelift.model.FleetAction]
  type FleetAttributesList = List[zio.aws.gamelift.model.FleetAttributes]
  type FleetCapacityList = List[zio.aws.gamelift.model.FleetCapacity]
  type FleetIdList = List[FleetId]
  type FleetIdOrArnList = List[FleetIdOrArn]
  type FleetUtilizationList = List[zio.aws.gamelift.model.FleetUtilization]
  type GamePropertyList = List[zio.aws.gamelift.model.GameProperty]
  type GameServerGroupActions =
    List[zio.aws.gamelift.model.GameServerGroupAction]
  type GameServerGroups = List[zio.aws.gamelift.model.GameServerGroup]
  type GameServerInstanceIds = List[GameServerInstanceId]
  type GameServerInstances = List[zio.aws.gamelift.model.GameServerInstance]
  type GameServers = List[zio.aws.gamelift.model.GameServer]
  type GameSessionDetailList = List[zio.aws.gamelift.model.GameSessionDetail]
  type GameSessionList = List[zio.aws.gamelift.model.GameSession]
  type GameSessionQueueDestinationList =
    List[zio.aws.gamelift.model.GameSessionQueueDestination]
  type GameSessionQueueList = List[zio.aws.gamelift.model.GameSessionQueue]
  type GameSessionQueueNameOrArnList = List[GameSessionQueueNameOrArn]
  type InstanceDefinitions = List[zio.aws.gamelift.model.InstanceDefinition]
  type InstanceList = List[zio.aws.gamelift.model.Instance]
  type IpPermissionsList = List[zio.aws.gamelift.model.IpPermission]
  type LatencyMap = Map[NonEmptyString, PositiveInteger]
  type LocationAttributesList = List[zio.aws.gamelift.model.LocationAttributes]
  type LocationConfigurationList =
    List[zio.aws.gamelift.model.LocationConfiguration]
  type LocationList = List[LocationStringModel]
  type LocationStateList = List[zio.aws.gamelift.model.LocationState]
  type MatchedPlayerSessionList =
    List[zio.aws.gamelift.model.MatchedPlayerSession]
  type MatchmakingConfigurationList =
    List[zio.aws.gamelift.model.MatchmakingConfiguration]
  type MatchmakingConfigurationNameList = List[MatchmakingConfigurationName]
  type MatchmakingIdList = List[MatchmakingIdStringModel]
  type MatchmakingRuleSetList = List[zio.aws.gamelift.model.MatchmakingRuleSet]
  type MatchmakingRuleSetNameList = List[MatchmakingRuleSetName]
  type MatchmakingTicketList = List[zio.aws.gamelift.model.MatchmakingTicket]
  type MetricGroupList = List[MetricGroup]
  type PlacedPlayerSessionList =
    List[zio.aws.gamelift.model.PlacedPlayerSession]
  type PlayerAttributeMap =
    Map[NonZeroAndMaxString, zio.aws.gamelift.model.AttributeValue]
  type PlayerDataMap = Map[NonZeroAndMaxString, PlayerData]
  type PlayerIdList = List[NonZeroAndMaxString]
  type PlayerLatencyList = List[zio.aws.gamelift.model.PlayerLatency]
  type PlayerLatencyPolicyList =
    List[zio.aws.gamelift.model.PlayerLatencyPolicy]
  type PlayerList = List[zio.aws.gamelift.model.Player]
  type PlayerSessionList = List[zio.aws.gamelift.model.PlayerSession]
  type PriorityTypeList = List[zio.aws.gamelift.model.PriorityType]
  type QueueArnsList = List[ArnStringModel]
  type ScalingPolicyList = List[zio.aws.gamelift.model.ScalingPolicy]
  type ScriptList = List[zio.aws.gamelift.model.Script]
  type ServerProcessList = List[zio.aws.gamelift.model.ServerProcess]
  type StringDoubleMap = Map[NonZeroAndMaxString, DoubleObject]
  type StringList = List[NonZeroAndMaxString]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.gamelift.model.Tag]
  type VpcPeeringAuthorizationList =
    List[zio.aws.gamelift.model.VpcPeeringAuthorization]
  type VpcPeeringConnectionList =
    List[zio.aws.gamelift.model.VpcPeeringConnection]
  type VpcSubnets = List[VpcSubnet]
}
