package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CertificateConfiguration(
    certificateType: zio.aws.gamelift.model.CertificateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CertificateConfiguration = {
    import CertificateConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CertificateConfiguration
      .builder()
      .certificateType(certificateType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CertificateConfiguration.ReadOnly =
    zio.aws.gamelift.model.CertificateConfiguration.wrap(buildAwsValue())
}
object CertificateConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CertificateConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CertificateConfiguration =
      zio.aws.gamelift.model.CertificateConfiguration(certificateType)
    def certificateType: zio.aws.gamelift.model.CertificateType
    def getCertificateType
        : ZIO[Any, Nothing, zio.aws.gamelift.model.CertificateType] =
      ZIO.succeed(certificateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CertificateConfiguration
  ) extends zio.aws.gamelift.model.CertificateConfiguration.ReadOnly {
    override val certificateType: zio.aws.gamelift.model.CertificateType =
      zio.aws.gamelift.model.CertificateType.wrap(impl.certificateType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CertificateConfiguration
  ): zio.aws.gamelift.model.CertificateConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
