package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClaimFilterOption(
    instanceStatuses: Optional[
      Iterable[zio.aws.gamelift.model.FilterInstanceStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ClaimFilterOption = {
    import ClaimFilterOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ClaimFilterOption
      .builder()
      .optionallyWith(
        instanceStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.instanceStatusesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ClaimFilterOption.ReadOnly =
    zio.aws.gamelift.model.ClaimFilterOption.wrap(buildAwsValue())
}
object ClaimFilterOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ClaimFilterOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ClaimFilterOption =
      zio.aws.gamelift.model
        .ClaimFilterOption(instanceStatuses.map(value => value))
    def instanceStatuses
        : Optional[List[zio.aws.gamelift.model.FilterInstanceStatus]]
    def getInstanceStatuses: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.FilterInstanceStatus
    ]] = AwsError.unwrapOptionField("instanceStatuses", instanceStatuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ClaimFilterOption
  ) extends zio.aws.gamelift.model.ClaimFilterOption.ReadOnly {
    override val instanceStatuses
        : Optional[List[zio.aws.gamelift.model.FilterInstanceStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.FilterInstanceStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ClaimFilterOption
  ): zio.aws.gamelift.model.ClaimFilterOption.ReadOnly = new Wrapper(impl)
}
