package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  DnsName,
  FleetId,
  FleetArn,
  Timestamp,
  ComputeArn,
  GameLiftServiceSdkEndpointOutput,
  LocationStringModel,
  IpAddress,
  ComputeName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Compute(
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    computeName: Optional[ComputeName] = Optional.Absent,
    computeArn: Optional[ComputeArn] = Optional.Absent,
    ipAddress: Optional[IpAddress] = Optional.Absent,
    dnsName: Optional[DnsName] = Optional.Absent,
    computeStatus: Optional[zio.aws.gamelift.model.ComputeStatus] =
      Optional.Absent,
    location: Optional[LocationStringModel] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    operatingSystem: Optional[zio.aws.gamelift.model.OperatingSystem] =
      Optional.Absent,
    `type`: Optional[zio.aws.gamelift.model.EC2InstanceType] = Optional.Absent,
    gameLiftServiceSdkEndpoint: Optional[GameLiftServiceSdkEndpointOutput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.Compute = {
    import Compute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.Compute
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        computeName.map(value => ComputeName.unwrap(value): java.lang.String)
      )(_.computeName)
      .optionallyWith(
        computeArn.map(value => ComputeArn.unwrap(value): java.lang.String)
      )(_.computeArn)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        dnsName.map(value => DnsName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(computeStatus.map(value => value.unwrap))(_.computeStatus)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        gameLiftServiceSdkEndpoint.map(value =>
          GameLiftServiceSdkEndpointOutput.unwrap(value): java.lang.String
        )
      )(_.gameLiftServiceSdkEndpoint)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.Compute.ReadOnly =
    zio.aws.gamelift.model.Compute.wrap(buildAwsValue())
}
object Compute {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.gamelift.model.Compute] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.Compute =
      zio.aws.gamelift.model.Compute(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        computeName.map(value => value),
        computeArn.map(value => value),
        ipAddress.map(value => value),
        dnsName.map(value => value),
        computeStatus.map(value => value),
        location.map(value => value),
        creationTime.map(value => value),
        operatingSystem.map(value => value),
        `type`.map(value => value),
        gameLiftServiceSdkEndpoint.map(value => value)
      )
    def fleetId: Optional[FleetId]
    def fleetArn: Optional[FleetArn]
    def computeName: Optional[ComputeName]
    def computeArn: Optional[ComputeArn]
    def ipAddress: Optional[IpAddress]
    def dnsName: Optional[DnsName]
    def computeStatus: Optional[zio.aws.gamelift.model.ComputeStatus]
    def location: Optional[LocationStringModel]
    def creationTime: Optional[Timestamp]
    def operatingSystem: Optional[zio.aws.gamelift.model.OperatingSystem]
    def `type`: Optional[zio.aws.gamelift.model.EC2InstanceType]
    def gameLiftServiceSdkEndpoint: Optional[GameLiftServiceSdkEndpointOutput]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getComputeName: ZIO[Any, AwsError, ComputeName] =
      AwsError.unwrapOptionField("computeName", computeName)
    def getComputeArn: ZIO[Any, AwsError, ComputeArn] =
      AwsError.unwrapOptionField("computeArn", computeArn)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getDnsName: ZIO[Any, AwsError, DnsName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getComputeStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ComputeStatus] =
      AwsError.unwrapOptionField("computeStatus", computeStatus)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.gamelift.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getType: ZIO[Any, AwsError, zio.aws.gamelift.model.EC2InstanceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getGameLiftServiceSdkEndpoint
        : ZIO[Any, AwsError, GameLiftServiceSdkEndpointOutput] =
      AwsError.unwrapOptionField(
        "gameLiftServiceSdkEndpoint",
        gameLiftServiceSdkEndpoint
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.Compute
  ) extends zio.aws.gamelift.model.Compute.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val computeName: Optional[ComputeName] = zio.aws.core.internal
      .optionalFromNullable(impl.computeName())
      .map(value => zio.aws.gamelift.model.primitives.ComputeName(value))
    override val computeArn: Optional[ComputeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.computeArn())
      .map(value => zio.aws.gamelift.model.primitives.ComputeArn(value))
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.gamelift.model.primitives.IpAddress(value))
    override val dnsName: Optional[DnsName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.gamelift.model.primitives.DnsName(value))
    override val computeStatus: Optional[zio.aws.gamelift.model.ComputeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeStatus())
        .map(value => zio.aws.gamelift.model.ComputeStatus.wrap(value))
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val operatingSystem
        : Optional[zio.aws.gamelift.model.OperatingSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value => zio.aws.gamelift.model.OperatingSystem.wrap(value))
    override val `type`: Optional[zio.aws.gamelift.model.EC2InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.gamelift.model.EC2InstanceType.wrap(value))
    override val gameLiftServiceSdkEndpoint
        : Optional[GameLiftServiceSdkEndpointOutput] = zio.aws.core.internal
      .optionalFromNullable(impl.gameLiftServiceSdkEndpoint())
      .map(value =>
        zio.aws.gamelift.model.primitives
          .GameLiftServiceSdkEndpointOutput(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.Compute
  ): zio.aws.gamelift.model.Compute.ReadOnly = new Wrapper(impl)
}
